/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.idoox.debug.Category;
import com.systinet.persistence.ClassParser;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.RetryPolicy;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.OrderBy;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class Query {
    private static Category log = Category.getCategory((String)"com.systinet.persistence.query.Query");
    private Class resultType;
    private Expression condition;
    private OrderBy order;
    private Set usedClasses;
    private int limit;
    private PersistentFieldFilter filter;
    private TransactionManager txMgr = null;
    private PreparedStatement statement = null;
    private boolean shouldClose = false;

    public Query(Expression condition) {
        this(condition, (PersistentFieldFilter)null);
    }

    public Query(Expression condition, PersistentFieldFilter fieldFilter) {
        this.usedClasses = condition.usedClasses();
        if (this.usedClasses.size() != 1) {
            throw new IllegalArgumentException("Condition not using 1 class: " + this.usedClasses);
        }
        this.resultType = (Class)this.usedClasses.iterator().next();
        this.condition = condition;
        this.order = null;
        this.limit = 0;
        this.filter = fieldFilter;
    }

    public Query(Class resultType) {
        this(resultType, null, null, 0);
    }

    public Query(Class resultType, OrderBy order) {
        this(resultType, order, null, 0);
    }

    public Query(Class resultType, OrderBy order, int limit) {
        this(resultType, order, null, limit);
    }

    public Query(Class resultType, PersistentFieldFilter fieldFilter) {
        this(resultType, null, fieldFilter, 0);
    }

    public Query(Class resultType, OrderBy order, PersistentFieldFilter fieldFilter) {
        this(resultType, order, fieldFilter, 0);
    }

    public Query(Class resultType, OrderBy order, PersistentFieldFilter fieldFilter, int limit) {
        if (resultType == null) {
            throw new NullPointerException("Param 'resultType' is null");
        }
        this.resultType = resultType;
        this.condition = null;
        this.order = order;
        this.usedClasses = Collections.singleton(resultType);
        this.limit = limit;
        this.filter = fieldFilter;
    }

    public Query(Expression condition, Class resultType) {
        this(condition, resultType, null, 0);
    }

    public Query(Expression condition, Class resultType, OrderBy order) {
        this(condition, resultType, order, 0);
    }

    public Query(Expression condition, Class resultType, OrderBy order, int limit) {
        this(condition, resultType, order, null, limit);
    }

    public Query(Expression condition, Class resultType, OrderBy order, PersistentFieldFilter fieldFilter) {
        this(condition, resultType, order, fieldFilter, 0);
    }

    public Query(Expression condition, Class resultType, OrderBy order, PersistentFieldFilter fieldFilter, int limit) {
        if (condition == null) {
            throw new NullPointerException("Param 'condition' is null");
        }
        if (resultType == null) {
            throw new NullPointerException("Param 'resultType' is null");
        }
        this.usedClasses = condition.usedClasses();
        this.condition = condition;
        this.resultType = resultType;
        this.order = order;
        this.limit = limit;
        this.filter = fieldFilter;
    }

    private Expression.PreparedSql toSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        boolean first = true;
        Iterator i = ClassParser.getPersistentFields(this.resultType).iterator();
        while (i.hasNext()) {
            Field cfield = (Field)i.next();
            if (this.filter != null && !this.filter.checkField(cfield)) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(cfield.getName());
        }
        if (first) {
            throw new IllegalStateException("No rows in SELECT, all filtered");
        }
        this.appendFrom(sb);
        List constants = this.appendWhere(sb);
        this.appendOrderBy(sb);
        return new Expression.PreparedSql(sb.toString(), constants);
    }

    private Expression.PreparedSql toCountSql(boolean distinct) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT COUNT(");
        if (distinct) {
            sb.append("DISTINCT ");
        }
        sb.append("*) ");
        this.appendFrom(sb);
        List constants = this.appendWhere(sb);
        return new Expression.PreparedSql(sb.toString(), constants);
    }

    private void appendFrom(StringBuffer sb) {
        sb.append(" FROM ");
        boolean first = true;
        Iterator i = this.usedClasses.iterator();
        while (i.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(ClassParser.getTableNameFor((Class)i.next()));
        }
    }

    private List appendWhere(StringBuffer sb) {
        List constants;
        if (this.condition != null) {
            sb.append(" WHERE ");
            Expression.PreparedSql prepSql = this.condition.toPreparedSql();
            constants = prepSql.constants;
            sb.append(prepSql.sqlScript);
        } else {
            constants = Collections.EMPTY_LIST;
        }
        return constants;
    }

    private void appendOrderBy(StringBuffer sb) {
        if (this.order != null) {
            sb.append(" ORDER BY ");
            sb.append(this.order.toSql());
        }
    }

    public String toString() {
        return this.toSql().toString();
    }

    public ResultSetIterator execute(RetryPolicy retryPolicy) throws PersistenceException {
        if (retryPolicy == null) {
            throw new NullPointerException("policy must not be null");
        }
        int attempt = 0;
        while (true) {
            try {
                ++attempt;
                return this.execute();
            }
            catch (PersistenceException pe) {
                long timeOut = retryPolicy.getRetryTimeout(attempt, (Exception)((Object)pe));
                if (timeOut < 0L) {
                    throw pe;
                }
                log.warn("Retrying SQL query, last failure: ", (Throwable)((Object)pe));
                if (timeOut == 0L) continue;
                try {
                    Thread.sleep(timeOut);
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                    continue;
                }
            }
            break;
        }
    }

    public ResultSetIterator execute() throws PersistenceException {
        return this.executeInternal(null);
    }

    public ResultSetIterator execute(ClassLoader loader) throws PersistenceException {
        return this.executeInternal(loader);
    }

    private ResultSetIterator executeInternal(ClassLoader loader) throws PersistenceException {
        try {
            this.close();
            PersistenceManager persMgr = PersistenceManager.getInstance();
            this.txMgr = persMgr.getDatabase().getTransactionManager();
            this.txMgr.beginReadOnly();
            this.shouldClose = true;
            ConnectionMonitor connection = this.txMgr.getConnection();
            Expression.PreparedSql prepSql = this.toSql();
            this.statement = connection.prepareStatement(prepSql.sqlScript);
            Query.setConstantsInPrepStmt(prepSql.constants, this.statement);
            if (this.limit > 0) {
                this.statement.setMaxRows(this.limit);
            }
            log.debug("Executing SQL query: " + prepSql.sqlScript);
            ResultSet result = this.statement.executeQuery();
            ResultSetIterator resultIterator = loader == null ? persMgr.iterate(result, this.resultType) : persMgr.iterate(result, this.resultType, loader);
            return new ResultSetIteratorWrapper(resultIterator);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    public int countRows() throws PersistenceException {
        if (this.shouldClose) {
            throw new IllegalStateException("Cannot count between execute and close");
        }
        try {
            int n;
            TransactionManager txMgr;
            block7: {
                PersistenceManager pm = PersistenceManager.getInstance();
                txMgr = pm.getDatabase().getTransactionManager();
                txMgr.beginReadOnly();
                PreparedStatement pstmt = null;
                try {
                    Expression.PreparedSql prepSql = this.toCountSql(false);
                    pstmt = txMgr.getConnection().prepareStatement(prepSql.sqlScript);
                    Query.setConstantsInPrepStmt(prepSql.constants, pstmt);
                    ResultSet rs = pstmt.executeQuery();
                    rs.next();
                    n = rs.getInt(1);
                    Object var8_9 = null;
                    if (pstmt == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (pstmt != null) {
                        txMgr.getConnection().close(pstmt);
                    }
                    txMgr.end();
                    throw throwable;
                }
                txMgr.getConnection().close(pstmt);
            }
            txMgr.end();
            return n;
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    static void setConstantsInPrepStmt(List constants, PreparedStatement pstmt) throws SQLException {
        int i = 0;
        int limit = constants.size();
        while (i < limit) {
            Constant cconst = (Constant)constants.get(i);
            cconst.setPrepStmtParam(pstmt, ++i);
        }
    }

    public void close() throws PersistenceException {
        try {
            log.debug("Closing SQL query; shouldClose=" + this.shouldClose);
            if (this.shouldClose) {
                this.shouldClose = false;
                if (this.statement != null) {
                    this.txMgr.getConnection().close(this.statement);
                }
                this.txMgr.end();
                this.txMgr = null;
                this.statement = null;
            }
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    private final class ResultSetIteratorWrapper
    implements ResultSetIterator {
        private ResultSetIterator wrappedIterator;

        ResultSetIteratorWrapper(ResultSetIterator wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        public boolean hasNext() throws PersistenceException {
            return this.wrappedIterator.hasNext();
        }

        public Object next() throws PersistenceException {
            return this.wrappedIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not supported in r/o tx");
        }
    }
}

