/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PersistentFieldCollection {
    private Set fieldSet = new HashSet();
    private List fieldList = new ArrayList();

    public PersistentFieldCollection() {
    }

    public PersistentFieldCollection(PersistentField[] pfs) {
        this.addAll(Arrays.asList(pfs));
    }

    public PersistentFieldCollection(Class clazz, String[] fieldNames) {
        PersistentClass persCl = PersistentClass.getInstance(clazz);
        int i = 0;
        while (i < fieldNames.length) {
            String cname = fieldNames[i];
            this.add(persCl.field(cname));
            ++i;
        }
    }

    public boolean contains(PersistentField pf) {
        return this.fieldSet.contains(pf);
    }

    public boolean contains(Field field) {
        PersistentClass pc = PersistentClass.getInstance(field.getDeclaringClass());
        PersistentField pf = pc.field(field.getName());
        return this.contains(pf);
    }

    public boolean contains(Class clazz, String fieldName) {
        try {
            return this.contains(clazz.getField(fieldName));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(fieldName + " not in " + clazz + " : " + e.getMessage());
        }
    }

    public boolean fieldsFromOneClass() {
        Class definedIn = null;
        Iterator i = this.fieldSet.iterator();
        while (i.hasNext()) {
            PersistentField cpf = (PersistentField)i.next();
            Class cdic = cpf.definedIn();
            if (definedIn == cdic) continue;
            if (definedIn == null) {
                definedIn = cdic;
                continue;
            }
            return false;
        }
        return true;
    }

    public Class getClassOfFields() {
        if (!this.fieldsFromOneClass() || this.isEmpty()) {
            return null;
        }
        return ((PersistentField)this.fieldList.get(0)).definedIn();
    }

    public boolean add(PersistentField pf) {
        boolean changed = this.fieldSet.add(pf);
        if (changed) {
            this.fieldList.add(pf);
        }
        return changed;
    }

    public boolean addAll(Collection persFields) {
        boolean change = false;
        Iterator i = persFields.iterator();
        while (i.hasNext()) {
            this.add((PersistentField)i.next());
        }
        return change;
    }

    public int size() {
        return this.fieldSet.size();
    }

    public boolean isEmpty() {
        return this.fieldSet.isEmpty();
    }

    public Iterator iterator() {
        return this.fieldList.iterator();
    }

    public String toSqlList() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int limit = this.fieldList.size();
        while (i < limit) {
            PersistentField cpf = (PersistentField)this.fieldList.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(cpf.name());
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSqlList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersistentFieldCollection)) {
            return false;
        }
        PersistentFieldCollection persistentFieldCollection = (PersistentFieldCollection)o;
        return this.fieldList.equals(persistentFieldCollection.fieldList);
    }

    public int hashCode() {
        return this.fieldList.hashCode();
    }
}

