/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.postgresql;

import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.FieldSetterManager;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgresqlSchemaHelper
extends DatabaseSchemaHelper {
    private static final String DOUBLE_PRECISION = "DOUBLE PRECISION";
    static /* synthetic */ Class class$com$systinet$persistence$tablemodel$Identity;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean existsTableInDb(String tableName, ConnectionMonitor cm) throws DatabaseCoreException, SQLException {
        boolean bl;
        if (tableName == null || tableName.length() == 0) {
            throw new NullPointerException("'tableName' is null or empty");
        }
        Statement stmt = null;
        try {
            stmt = cm.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT 1 FROM pg_tables WHERE lower(tablename)=lower(" + this.quote(tableName, false) + ")");
            bl = rs.next();
            Object var7_6 = null;
            if (stmt == null) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (stmt == null) throw throwable;
            cm.close(stmt);
            throw throwable;
        }
        cm.close(stmt);
        return bl;
    }

    protected String getSqlForBoolean() {
        return "BOOLEAN";
    }

    protected String getSqlForByte() {
        return "SMALLINT";
    }

    protected String getSqlForFloat() {
        return DOUBLE_PRECISION;
    }

    protected String getSqlForDouble() {
        return DOUBLE_PRECISION;
    }

    protected String getSqlForOtherTypes() {
        return "BYTEA";
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter() {
        return FieldSetterManager.BINARY_FIELD_SETTER;
    }

    protected void registerNonPrimitiveTypes() {
        this.registerTypeMapping(class$com$systinet$persistence$tablemodel$Identity == null ? (class$com$systinet$persistence$tablemodel$Identity = PostgresqlSchemaHelper.class$("com.systinet.persistence.tablemodel.Identity")) : class$com$systinet$persistence$tablemodel$Identity, "serial8 NOT NULL");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

