/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.hsql;

import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.FieldSetterManager;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.tablemodel.Column;
import com.systinet.persistence.tablemodel.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class HsqlSchemaHelper
extends DatabaseSchemaHelper {
    private static final HsqlDefaultSetter HSQL_DEFAULT_SETTER_INSTANCE = new HsqlDefaultSetter();
    static /* synthetic */ Class class$com$systinet$persistence$tablemodel$Identity;

    protected String processSearchTableName(String originalName) {
        return originalName.toUpperCase();
    }

    protected boolean supportsSelectForUpdate() {
        return false;
    }

    protected String getSqlForOtherTypes() {
        return "OBJECT";
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter() {
        return HSQL_DEFAULT_SETTER_INSTANCE;
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter(ClassLoader loader) {
        return new HsqlDefaultSetter(loader);
    }

    protected String getCreateTableStr() {
        return "CREATE CACHED TABLE";
    }

    protected String createForeingKeyConstaint(Column column) {
        return null;
    }

    protected String getConstraintInsertions(Table table) {
        StringBuffer sb = new StringBuffer(super.getConstraintInsertions(table));
        Iterator i = table.columns().iterator();
        while (i.hasNext()) {
            Column ccol = (Column)i.next();
            if (!ccol.isForeignKey()) continue;
            sb.append(", FOREIGN KEY (");
            sb.append(ccol.getName());
            sb.append(") REFERENCES ");
            sb.append(ccol.foreingKeyReferences());
        }
        return sb.toString();
    }

    protected void registerNonPrimitiveTypes() {
        super.registerNonPrimitiveTypes();
        this.registerTypeMapping(class$com$systinet$persistence$tablemodel$Identity == null ? (class$com$systinet$persistence$tablemodel$Identity = HsqlSchemaHelper.class$("com.systinet.persistence.tablemodel.Identity")) : class$com$systinet$persistence$tablemodel$Identity, "int IDENTITY");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HsqlDefaultSetter
    implements FieldSetterManager.FieldSetter {
        private final ClassLoader loader;

        HsqlDefaultSetter() {
            this.loader = null;
        }

        public HsqlDefaultSetter(ClassLoader loader) {
            if (loader == null) {
                throw new NullPointerException("Param loader is null");
            }
            this.loader = loader;
        }

        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            byte[] serObject = (byte[])source.getObject(colIndex);
            try {
                Object value = null;
                if (serObject != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(serObject);
                    ObjectInputStream ois = this.loader != null ? new FieldSetterManager.ObjectInputStreamWithLoader(is, this.loader) : new ObjectInputStream(is);
                    value = ois.readObject();
                }
                field.set(instance, value);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PersistenceException("Class to be deserialized from byte[] in HSQL not found: " + cnfe.getMessage(), cnfe);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error derializing byte[] from HSQL " + field.getName() + "': " + ioe.getMessage(), ioe);
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            try {
                Object obj = fromField.get(source);
                if (obj == null) {
                    pstmt.setNull(colIndex, 1111);
                    return;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                pstmt.setObject(colIndex, (Object)baos.toByteArray(), 1111);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Cannot serialize a class: " + ioe.getMessage(), ioe);
            }
        }
    }
}

