/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.idoox.debug.Category;
import com.systinet.persistence.ClassParser;
import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.FieldSetterManager;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.RetryPolicy;
import com.systinet.persistence.SqlToJavaMapper;
import com.systinet.persistence.TableCreator;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.Database;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class PersistenceManager {
    private static Category log = Category.getCategory((String)"com.systinet.persistence.PersistenceManager");
    private static final PersistenceManager INSTANCE = new PersistenceManager();
    private static final String COMMA_SPACE = ", ";
    private static Map sqlCommandsCache = new HashMap();

    public static PersistenceManager getInstance() {
        return INSTANCE;
    }

    private PersistenceManager() {
    }

    public void createTables(Class[] classes) throws PersistenceException {
        this.createTables(classes, new PersistentFieldCollection[0]);
    }

    public void createTables(Class[] classes, PersistentFieldCollection[] indexes) throws PersistenceException {
        try {
            TableCreator creator = new TableCreator();
            creator.parseClasses(classes);
            creator.createTableWithIndexes(this.getDatabase(), indexes);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    public void dropTables(Class[] classes) throws PersistenceException {
        try {
            TableCreator creator = new TableCreator();
            creator.parseClasses(classes);
            creator.dropTables(this.getDatabase());
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    public ResultSetIterator iterate(ResultSet resultSet, Class persistentClass) throws PersistenceException {
        return this.iterateInternal(resultSet, persistentClass, null);
    }

    public ResultSetIterator iterate(ResultSet resultSet, Class persistentClass, ClassLoader classLoader) throws PersistenceException {
        return this.iterateInternal(resultSet, persistentClass, classLoader);
    }

    private ResultSetIterator iterateInternal(ResultSet resultSet, Class persistentClass, ClassLoader loader) throws PersistenceException {
        int concurrency = 1007;
        try {
            concurrency = resultSet.getConcurrency();
        }
        catch (SQLException e) {
            log.warn("Error in ResultSet.getConcurrency()", (Throwable)e);
        }
        if (concurrency == 1008) {
            return new ResultSetIteratorImpl(resultSet, persistentClass, loader);
        }
        return new UnmodifableResultSetIterator(resultSet, persistentClass, loader);
    }

    public void insert(Object obj) throws PersistenceException {
        this.insertOrUpdateOrStore(obj, false, true);
    }

    public void insert(Object obj, RetryPolicy retryPolicy) throws PersistenceException {
        this.insertOrUpdateOrStore(obj, false, true, null, retryPolicy);
    }

    private int insertOrUpdateOrStore(Object obj, boolean store, boolean insert) throws PersistenceException {
        return this.insertOrUpdateOrStore(obj, store, insert, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int insertOrUpdateOrStore(Object obj, boolean store, boolean insert, PersistentFieldFilter filter) throws PersistenceException {
        try {
            int n;
            TransactionManager tm = this.getDatabase().getTransactionManager();
            tm.beginReadWrite();
            boolean ok = false;
            try {
                ConnectionMonitor conn = tm.getConnection();
                int rowCount = -1;
                if (store) {
                    this.store(obj, conn);
                } else if (insert) {
                    this.insert(obj, conn);
                } else {
                    rowCount = this.update(obj, conn, filter);
                }
                tm.commit();
                ok = true;
                n = rowCount;
                Object var11_12 = null;
                if (ok) return n;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (ok) throw throwable;
                try {
                    tm.rollback();
                    throw throwable;
                }
                catch (DatabaseCoreException ignored) {
                    log.error("Cannot rollback failed transaction", (Throwable)((Object)ignored));
                }
                throw throwable;
            }
            try {
                tm.rollback();
                return n;
            }
            catch (DatabaseCoreException ignored) {
                log.error("Cannot rollback failed transaction", (Throwable)((Object)ignored));
            }
            return n;
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    private int insertOrUpdateOrStore(Object obj, boolean store, boolean insert, PersistentFieldFilter filter, RetryPolicy retryPolicy) throws PersistenceException {
        if (retryPolicy == null) {
            throw new NullPointerException("policy must not be null");
        }
        int attempt = 0;
        while (true) {
            try {
                ++attempt;
                return this.insertOrUpdateOrStore(obj, store, insert, filter);
            }
            catch (PersistenceException pe) {
                long timeOut = retryPolicy.getRetryTimeout(attempt, (Exception)((Object)pe));
                if (timeOut < 0L) {
                    throw pe;
                }
                log.warn("Retrying SQL DML operation, last failure: ", (Throwable)((Object)pe));
                if (timeOut == 0L) continue;
                try {
                    Thread.sleep(timeOut);
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn((Object)e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(Object obj, ConnectionMonitor conn) throws PersistenceException {
        try {
            PreparedStatement insertStmt = null;
            try {
                SqlCommandsData sqlCmdsData = PersistenceManager.createSqlCommands(obj.getClass());
                insertStmt = conn.prepareStatement(sqlCmdsData.insertScript);
                PersistenceManager.setParamsInInsert(sqlCmdsData, insertStmt, obj);
                insertStmt.executeUpdate();
                Object var6_7 = null;
                if (insertStmt == null) return;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (insertStmt == null) throw throwable;
                conn.close(insertStmt);
                throw throwable;
            }
            conn.close(insertStmt);
            return;
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    public int update(Object obj) throws PersistenceException {
        return this.insertOrUpdateOrStore(obj, false, false);
    }

    public int update(Object obj, PersistentFieldFilter filter) throws PersistenceException {
        return this.insertOrUpdateOrStore(obj, false, false, filter);
    }

    public int update(Object obj, PersistentFieldFilter filter, RetryPolicy retryPolicy) throws PersistenceException {
        return this.insertOrUpdateOrStore(obj, false, false, filter, retryPolicy);
    }

    public int update(Object obj, ConnectionMonitor conn) throws PersistenceException {
        return this.update(obj, conn, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int update(Object obj, ConnectionMonitor conn, PersistentFieldFilter filter) throws PersistenceException {
        try {
            int n;
            PreparedStatement updateStmt = null;
            try {
                SqlCommandsData sqlCmdsData = PersistenceManager.createSqlCommands(obj.getClass(), filter);
                updateStmt = conn.prepareStatement(sqlCmdsData.updateScript);
                PersistenceManager.setParamsInUpdate(sqlCmdsData, updateStmt, obj);
                n = updateStmt.executeUpdate();
                Object var8_9 = null;
                if (updateStmt == null) return n;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (updateStmt == null) throw throwable;
                conn.close(updateStmt);
                throw throwable;
            }
            conn.close(updateStmt);
            return n;
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    public void store(Object obj) throws PersistenceException {
        this.insertOrUpdateOrStore(obj, true, false);
    }

    public void store(Object obj, RetryPolicy retryPolicy) throws PersistenceException {
        this.insertOrUpdateOrStore(obj, true, false, null, retryPolicy);
    }

    public void store(Object obj, ConnectionMonitor conn) throws PersistenceException {
        try {
            PreparedStatement storeStmt;
            block12: {
                PreparedStatement checkIsNewStmt = null;
                storeStmt = null;
                try {
                    Class<?> objectClass = obj.getClass();
                    SqlCommandsData sqlCmdsData = PersistenceManager.createSqlCommands(objectClass);
                    ResultSet checkIsNewRs = null;
                    if (!sqlCmdsData.primaryKey.isEmpty()) {
                        String sqlSelect = PersistenceManager.createCheckSelect(objectClass, sqlCmdsData.primaryKey);
                        checkIsNewStmt = conn.prepareStatement(sqlSelect);
                        int i = 0;
                        int limit = sqlCmdsData.primaryKey.size();
                        while (i < limit) {
                            Field cPkF = (Field)sqlCmdsData.primaryKey.get(i);
                            PersistenceManager.setStatementParam(checkIsNewStmt, i + 1, cPkF, obj);
                            ++i;
                        }
                        checkIsNewRs = checkIsNewStmt.executeQuery();
                    }
                    if (checkIsNewRs != null && checkIsNewRs.next()) {
                        storeStmt = conn.prepareStatement(sqlCmdsData.updateScript);
                        PersistenceManager.setParamsInUpdate(sqlCmdsData, storeStmt, obj);
                        storeStmt.executeUpdate();
                    } else {
                        storeStmt = conn.prepareStatement(sqlCmdsData.insertScript);
                        PersistenceManager.setParamsInInsert(sqlCmdsData, storeStmt, obj);
                        storeStmt.executeUpdate();
                    }
                    Object var13_14 = null;
                    if (checkIsNewStmt == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (checkIsNewStmt != null) {
                        conn.close(checkIsNewStmt);
                    }
                    if (storeStmt != null) {
                        conn.close(storeStmt);
                    }
                    throw throwable;
                }
                conn.close(checkIsNewStmt);
            }
            if (storeStmt != null) {
                conn.close(storeStmt);
            }
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
    }

    private static String createCheckSelect(Class clazz, List pk) throws PersistenceException {
        DatabaseSchemaHelper dbSchemaHelper = DatabaseSchemaHelper.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT 1 FROM ");
        sb.append(ClassParser.getTableNameFor(clazz));
        if (dbSchemaHelper.supportMsSqlHintForUpdate()) {
            sb.append(" WITH (UPDLOCK)");
        }
        sb.append(" WHERE ");
        int i = 0;
        int limit = pk.size();
        while (i < limit) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append(((Field)pk.get(i)).getName());
            sb.append("=?");
            ++i;
        }
        if (dbSchemaHelper.supportsSelectForUpdate()) {
            sb.append(" FOR UPDATE");
        }
        return sb.toString();
    }

    private static void setParamsInUpdate(SqlCommandsData insData, PreparedStatement storeStmt, Object o) throws PersistenceException {
        int i = 0;
        int updPos = 1;
        int limit = insData.columns;
        int pkPos = limit - insData.primaryKey.size() + 1;
        while (i < limit) {
            Field curField = (Field)insData.params.get(i);
            if (curField.getName().endsWith("PK")) {
                PersistenceManager.setStatementParam(storeStmt, pkPos++, curField, o);
            } else {
                PersistenceManager.setStatementParam(storeStmt, updPos++, curField, o);
            }
            ++i;
        }
    }

    private static void setParamsInInsert(SqlCommandsData sqlCmdsData, PreparedStatement storeStmt, Object o) throws PersistenceException {
        int i = 1;
        int limit = sqlCmdsData.columns;
        while (i <= limit) {
            Field curField = (Field)sqlCmdsData.params.get(i - 1);
            PersistenceManager.setStatementParam(storeStmt, i, curField, o);
            ++i;
        }
    }

    private static void setStatementParam(PreparedStatement pstmt, int colIndex, Field fromField, Object o) throws PersistenceException {
        try {
            Class<?> fieldType = fromField.getType();
            FieldSetterManager.FieldSetter fs = DatabaseSchemaHelper.getInstance().findSetter(fieldType, null);
            if (fs == null) {
                fs = DatabaseSchemaHelper.getInstance().getDefaultSetter();
            }
            fs.setStatement(pstmt, colIndex, fromField, o);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException("Problem with " + fromField + ": " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new PersistenceException("Problem with " + fromField + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Problem with " + fromField + ": " + e.getMessage(), e);
        }
    }

    private static SqlCommandsData createSqlCommands(Class clazz) throws PersistenceException {
        return PersistenceManager.createSqlCommands(clazz, null);
    }

    private static SqlCommandsData createSqlCommands(Class clazz, PersistentFieldFilter filter) throws PersistenceException {
        SqlCommandsData res = null;
        if (filter == null && (res = (SqlCommandsData)sqlCommandsCache.get(clazz)) != null) {
            return res;
        }
        Field[] fields = clazz.getFields();
        res = new SqlCommandsData();
        res.params = new ArrayList(fields.length);
        StringBuffer insColNames = new StringBuffer();
        StringBuffer updColNames = new StringBuffer();
        int i = 0;
        while (i < fields.length) {
            Field curField = fields[i];
            if (ClassParser.canBePersistentField(curField) && (filter == null || filter.checkField(curField) || curField.getName().endsWith("PK"))) {
                String fieldName = curField.getName();
                if (insColNames.length() != 0) {
                    insColNames.append(COMMA_SPACE);
                }
                insColNames.append(fieldName);
                if (fieldName.endsWith("PK")) {
                    res.primaryKey.add(curField);
                } else {
                    if (updColNames.length() != 0) {
                        updColNames.append(COMMA_SPACE);
                    }
                    updColNames.append(fieldName).append("=?");
                }
                ++res.columns;
                res.params.add(curField);
            }
            ++i;
        }
        String tableName = ClassParser.getTableNameFor(clazz);
        res.insertScript = "INSERT INTO " + tableName + "(" + insColNames + ") VALUES " + PersistenceManager.getPreparedInsertValues(res.columns);
        if (res.primaryKey != null) {
            StringBuffer sb = new StringBuffer();
            int i2 = 0;
            int limit = res.primaryKey.size();
            while (i2 < limit) {
                Field cPkCol = (Field)res.primaryKey.get(i2);
                if (i2 != 0) {
                    sb.append(" AND ");
                }
                sb.append(cPkCol.getName());
                sb.append("=?");
                ++i2;
            }
            res.updateScript = "UPDATE " + tableName + (DatabaseSchemaHelper.getInstance().supportMsSqlHintForUpdate() && tableName.equals("DbSequenceData") ? " WITH (TABLOCKX)" : "") + " SET " + updColNames + " WHERE " + sb.toString();
        }
        if (filter == null) {
            sqlCommandsCache.put(clazz, res);
        }
        return res;
    }

    private static String getPreparedInsertValues(int count) {
        StringBuffer sb = new StringBuffer(count * 3);
        sb.append('(');
        while (count > 0) {
            sb.append('?');
            if (count > 1) {
                sb.append(COMMA_SPACE);
            }
            --count;
        }
        sb.append(')');
        return sb.toString();
    }

    public Database getDatabase() throws PersistenceDbCoreException {
        try {
            return ApiManager.getApiManager().getDatabase();
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException("Cannot get ApiManager", e);
        }
    }

    private static class SqlCommandsData {
        String insertScript;
        String updateScript;
        int columns;
        List params;
        List primaryKey = new ArrayList();

        private SqlCommandsData() {
        }

        public String toString() {
            return "SqlCommandsData: insertScript=" + this.insertScript + ", updateScrip=" + this.updateScript + ", columns=" + this.columns + ", params=" + this.params + ", PK=" + this.primaryKey;
        }
    }

    private static class UnmodifableResultSetIterator
    extends ResultSetIteratorImpl {
        UnmodifableResultSetIterator(ResultSet rs, Class clazz, ClassLoader loader) throws PersistenceException {
            super(rs, clazz, loader);
        }

        public void remove() {
            throw new UnsupportedOperationException("Working over unmodifiable result set");
        }
    }

    private static class ResultSetIteratorImpl
    implements ResultSetIterator {
        private boolean nextCalled;
        private boolean hasNext;
        private boolean canRemove;
        private ResultSet rs;
        private SqlToJavaMapper.UnpackData unpackData;

        ResultSetIteratorImpl(ResultSet rs, Class clazz, ClassLoader loader) throws PersistenceException {
            if (rs == null) {
                throw new NullPointerException("'rs' must not be null");
            }
            if (clazz == null) {
                throw new NullPointerException("'clazz' must not be null");
            }
            this.rs = rs;
            this.canRemove = false;
            this.nextCalled = false;
            this.hasNext = false;
            this.unpackData = SqlToJavaMapper.prepareUnpack(rs, clazz, loader);
        }

        private void callNext() throws PersistenceSqlException {
            try {
                if (this.nextCalled) {
                    return;
                }
                this.hasNext = this.rs.next();
                this.nextCalled = true;
            }
            catch (SQLException e) {
                throw new PersistenceSqlException(e);
            }
        }

        public boolean hasNext() throws PersistenceSqlException {
            this.callNext();
            return this.hasNext;
        }

        public Object next() throws PersistenceException {
            this.callNext();
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.canRemove = true;
            this.nextCalled = false;
            return SqlToJavaMapper.unpack(this.rs, this.unpackData);
        }

        public void remove() throws PersistenceSqlException {
            if (!this.canRemove) {
                throw new IllegalStateException("next not called or removing for 2nd time");
            }
            try {
                this.rs.deleteRow();
                this.canRemove = false;
            }
            catch (SQLException sqle) {
                throw new PersistenceSqlException(sqle);
            }
        }
    }
}

