/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.validator.serialization;

import com.idoox.debug.Category;
import com.systinet.wasp.validator.serialization.ProxyDeSerializerHelper;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.xml.schema.validation.ValidationConfig;

public class ValidatingSerializerProxy
implements XMLSerializer {
    private static final Category dbg = Category.getCategory((String)"com.systinet.wasp.validator.serialization.ValidatingSerializerProxy");
    private static XMLSerializer validatingS;
    private static Map configCache;

    private ValidationConfig getCurrentValidationConfig() {
        ValidationConfig retVal;
        if (Current.getProcessingType() == 2) {
            ServiceEndpointContext sec = Current.getServiceEndpointContext();
            retVal = (ValidationConfig)configCache.get(sec);
            if (retVal != null) {
                return retVal;
            }
            retVal = ProxyDeSerializerHelper.getValidationConfig(sec);
            configCache.put(sec, retVal);
        } else {
            ServiceClientContext scc = Current.getServiceClientContext();
            retVal = (ValidationConfig)configCache.get(scc);
            if (retVal != null) {
                return retVal;
            }
            retVal = ProxyDeSerializerHelper.getValidationConfig(scc);
            configCache.put(scc, retVal);
        }
        return retVal;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ValidationConfig vCfg = this.getCurrentValidationConfig();
        if ((vCfg.getDirection() & 2) != 0) {
            if (validatingS != null) {
                validatingS.serialize(dataWriter, data, context, next);
                return;
            }
            dbg.error("validation desired but validator unavailable: check your installation");
        }
        XMLSerializer serializer = (XMLSerializer)next.getNextSerializerAs("systinet:xmlser/1.0");
        serializer.serialize(dataWriter, data, context, next);
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
        validatingS = ProxyDeSerializerHelper.createValidatingSerializer();
        if (validatingS != null) {
            validatingS.init(configurable);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    static {
        configCache = Collections.synchronizedMap(new WeakHashMap());
    }
}

