/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;

public abstract class XMLEnumIterSerializer
implements XMLSerializer {
    protected static Map cachedEnumIters = new HashMap();

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable configurable) {
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            Member m = context.getCurrentMember();
            QName schemaTypeQName = context.getCurrentConstructSchemaType().getName();
            dataWriter.enter(m.getName().getNamespaceURI(), m.getName().getLocalPart());
            String prefix = dataWriter.getPrefixForNamespace(schemaTypeQName.getNamespaceURI());
            dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + schemaTypeQName.getLocalPart());
            SchemaContext.State state = context.enterCurrentMember();
            context.nextMember();
            Object[] objs = this.getAllFromCache(data);
            this.removeDataFromCache(data);
            SerializationHelper.serialize((TokenWriter)dataWriter, (Object)objs, (SerializationContext)context);
            context.leave(state);
            dataWriter.leave();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        Member m = context.getCurrentMember();
        if (context.registerReference(data, m.getType()) == null) {
            while (this.hasNext(data)) {
                Object item = this.next(data);
                this.toCache(data, item);
            }
            this.listCacheToArray(data);
            SchemaContext.State state = context.enterCurrentMember();
            context.nextMember();
            SerializationHelper.grabReferences((Object)this.getAllFromCache(data), (SerializationContext)context);
            context.leave(state);
        }
    }

    private void listCacheToArray(Object data) {
        ArrayList cei = null;
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            cei = (ArrayList)cachedEnumIters.get(dataKey);
            cachedEnumIters.put(dataKey, cei.toArray());
        }
    }

    void removeDataFromCache(Object data) {
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            cachedEnumIters.remove(dataKey);
        }
    }

    Object[] getAllFromCache(Object data) {
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            Object[] ret = (Object[])cachedEnumIters.get(dataKey);
            return ret;
        }
        ArrayList<Object> al = new ArrayList<Object>();
        while (this.hasNext(data)) {
            Object item = this.next(data);
            al.add(item);
        }
        if (al.size() > 0) {
            return al.toArray();
        }
        return null;
    }

    private void toCache(Object data, Object item) {
        ArrayList cei = null;
        if (cachedEnumIters.containsKey(this.toHashCodeString(data))) {
            cei = (ArrayList)cachedEnumIters.get(this.toHashCodeString(data));
        } else {
            cei = new ArrayList();
            cachedEnumIters.put(this.toHashCodeString(data), cei);
        }
        cei.add(item);
    }

    private String toHashCodeString(Object data) {
        return data.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(data));
    }

    protected abstract boolean hasNext(Object var1);

    protected abstract Object next(Object var1);
}

