/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.util.xml.DOM2XMLWriter;
import com.idoox.wasp.serialization.SerializationHelper;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLElementSerializer
implements XMLSerializer {
    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            Element element;
            if (data instanceof Document) {
                element = ((Document)data).getDocumentElement();
            } else if (data instanceof Element) {
                element = (Element)data;
            } else {
                throw new MessageCreatingException("Serialization is not suported for a DOM class " + data.getClass().getName());
            }
            boolean isAnyComplexType = SerializationHelper.isAnyComplexType((SchemaContext)context);
            if (element == null) {
                if (isAnyComplexType) {
                    SerializationHelper.writeNil((TokenWriter)dataWriter, (QName)context.getCurrentConstructName());
                    return;
                }
                throw new MessageCreatingException("Sending Document with <null> root element is not allowed");
            }
            QName name = context.getCurrentConstructName();
            boolean isMember = context.getCurrentSchemaConstruct() instanceof Member;
            if (isMember) {
                dataWriter.enter(name.getNamespaceURI(), name.getLocalPart());
            }
            DOM2XMLWriter.writeElement((Element)element, (TokenWriter)dataWriter);
            if (isMember) {
                dataWriter.leave();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable conf) {
    }
}

