/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.wasp.serialization.PolymorphismHelper;
import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Serializer;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.xml.schema.validation.ValidationConfig;
import org.systinet.xml.schema.validation.ValidationException;

public class XMLBasicConstructSerializer
implements XMLSerializer {
    PolymorphismHelper helper = new PolymorphismHelper();

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Type polymorphismType;
            Member actElement;
            if (data == null) {
                if (context.getCurrentConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                    Member member = (Member)context.getCurrentSchemaConstruct();
                    int minOccurs = member.getMinOccurs();
                    int maxOccurs = member.getMaxOccurs();
                    if (minOccurs != 0) {
                        if (!member.isNillable() && this.shouldValidateNillableOut()) {
                            throw new ValidationException("Unable to serialize 'null' value according to schema element " + member.getName() + ". Schema element declares nillable='false'.");
                        }
                        SerializationHelper.writeNil((TokenWriter)dataWriter, (QName)context.getCurrentConstructName());
                    } else if (maxOccurs != 1 && member.isNillable()) {
                        SerializationHelper.writeNil((TokenWriter)dataWriter, (QName)context.getCurrentConstructName());
                    }
                }
                return;
            }
            if (context.getCurrentConstructType() == SchemaConstruct.ConstructType.MEMBER && (actElement = (Member)context.getCurrentSchemaConstruct()).isSubstitutable()) {
                Type actType = actElement.getType();
                Member toSubstitute = null;
                Iterator subst = actElement.getSubstitutionElements().values().iterator();
                while (subst.hasNext()) {
                    Member substMember = (Member)subst.next();
                    Type substType = substMember.getType();
                    String className = context.getType(substType);
                    if (className == null) continue;
                    Class<?> cls = null;
                    try {
                        cls = data.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        cls = null;
                    }
                    if (cls == null || !PolymorphismHelper.isExtendedFrom((Type)substType, (Type)actType) || substType == actType || !cls.isAssignableFrom(data.getClass()) || toSubstitute != null && (substType == toSubstitute.getType() || !PolymorphismHelper.isExtendedFrom((Type)substType, (Type)toSubstitute.getType()))) continue;
                    toSubstitute = substMember;
                }
                if (toSubstitute != null) {
                    context.replaceTopSchemaConstruct(toSubstitute);
                }
            }
            if ((polymorphismType = context.getMultirefType(data)) == null) {
                polymorphismType = this.helper.getClassSchemaType(context, data.getClass());
            }
            Type currentType = context.getCurrentConstructSchemaType();
            Type previousType = null;
            if (polymorphismType != null && polymorphismType != currentType) {
                if (PolymorphismHelper.isExtendedFrom((Type)polymorphismType, (Type)currentType)) {
                    previousType = currentType;
                    context.replaceTopMemberType(polymorphismType);
                    chain = context.getSerializationChain(data.getClass());
                    chain.removeSerializer((Serializer)this);
                }
            }
            if (context.getCurrentConstructSchemaType().isAbstract()) {
                throw new MessageCreatingException("Cannot serialize an instance of class '" + data.getClass() + "'. Only abstact schema type (" + currentType + ") found in WSDL.");
            }
            XMLSerializer nextSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
            if (nextSerializer == null) {
                throw new MessageCreatingException("No serializer found for xml schema " + context.getCurrentSchemaConstruct() + ", java class " + data.getClass());
            }
            nextSerializer.serialize(dataWriter, data, context, chain);
            if (previousType != null) {
                context.releaseSerializationChain(chain);
                context.replaceTopMemberType(previousType);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    private boolean shouldValidateNillableOut() {
        CallContext callContext = Current.getCallContext();
        if (callContext == null) {
            return false;
        }
        ValidationConfig conf = (ValidationConfig)callContext.getContextData().get("validation.config.key");
        return conf != null && (conf.getDirection() & 2) > 0 && (conf.getValidationType() & 2) > 0;
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        XMLSerializer nextSerializer;
        if (data == null) {
            return;
        }
        Type polymorphismType = context.getMultirefType(data);
        if (polymorphismType == null) {
            polymorphismType = this.helper.getClassSchemaType(context, data.getClass());
        }
        Type currentType = context.getCurrentConstructSchemaType();
        Type previousType = null;
        if (polymorphismType != null && polymorphismType != currentType) {
            if (PolymorphismHelper.isExtendedFrom((Type)polymorphismType, (Type)currentType)) {
                previousType = currentType;
                context.replaceTopMemberType(polymorphismType);
                chain = context.getSerializationChain(data.getClass());
                chain.removeSerializer((Serializer)this);
            }
        }
        if ((nextSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0")) == null) {
            throw new MessageCreatingException("No serializer found for xml schema " + context.getCurrentSchemaConstruct() + ", java class " + data.getClass());
        }
        nextSerializer.grabReferences(data, context, chain);
        if (previousType != null) {
            context.releaseSerializationChain(chain);
            context.replaceTopMemberType(previousType);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

