/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.javabuiltin.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class ListSerializer
implements Serializer {
    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Member member = (Member)context.getCurrentSchemaConstruct();
            dataWriter.writeStructureStart(member.getName(), member.getType().getName(), arrayPos, context.getMultirefId(data));
            List list = (List)data;
            SchemaContext.State listState = context.enterCurrentMember();
            member = context.nextMember();
            QName memberName = member.getName();
            SchemaContext.State arrayState = context.enterCurrentMember();
            member = context.nextMember();
            dataWriter.writeArrayStart(memberName, member.getType().getName(), new int[]{list.size()}, arrayPos, null);
            list = (List)data;
            Member fakeMember = new Member(member.getName(), member.getType(), true);
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                SchemaContext.State itemState = context.putSchemaConstruct((SchemaConstruct)fakeMember);
                SerializationHelper.serialize((EncodingTokenWriter)dataWriter, listIter.next(), (int[])arrayPos, (SerializationContext)context);
                context.leave(itemState);
            }
            dataWriter.writeArrayEnd();
            context.leave(arrayState);
            context.leave(listState);
            dataWriter.writeStructureEnd();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException("Exception occured while serializing List structure", (Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Member member = (Member)context.getCurrentSchemaConstruct();
            if (context.registerReference(data, member.getType()) == null) {
                SchemaContext.State listState = context.enterCurrentMember();
                context.nextMember();
                SchemaContext.State arrayState = context.enterCurrentMember();
                member = context.nextMember();
                List list = (List)data;
                Iterator listIter = list.iterator();
                while (listIter.hasNext()) {
                    SchemaContext.State itemState = context.putSchemaConstruct((SchemaConstruct)member);
                    SerializationHelper.grabReferences(listIter.next(), (SerializationContext)context);
                    context.leave(itemState);
                }
                context.leave(arrayState);
                context.leave(listState);
            }
        }
        catch (Exception e) {
            throw new MessageCreatingException("Exception occured while registering List structure", (Throwable)e);
        }
    }

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void init(Configurable conf) {
    }
}

