/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.javabuiltin;

import com.idoox.wasp.Constants;
import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class MapSerializer
implements Serializer {
    protected QName structType;
    static QName itemQName = new QName(null, "item");

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public MapSerializer() {
        this("http://xml.apache.org/xml-soap", "Map");
    }

    protected MapSerializer(String structNamespace, String structName) {
        this.setStructParams(structNamespace, structName);
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Map dataMap = (Map)data;
        Iterator it = dataMap.entrySet().iterator();
        Member m = context.getCurrentMember();
        String id = context.getMultirefId(data);
        dataWriter.writeStructureStart(m.getName(), this.structType, arrayPos, id);
        SchemaContext.State state = context.enterCurrentMember();
        Member nextMember = context.nextMember();
        while (it.hasNext()) {
            dataWriter.writeStructureStart(itemQName, Constants.nullQName, null, null);
            Map.Entry mapEntry = it.next();
            SchemaContext.State itemState = context.enterCurrentMember();
            nextMember = context.nextMember();
            Object key = mapEntry.getKey();
            SerializationHelper.serialize((EncodingTokenWriter)dataWriter, key, null, (SerializationContext)context);
            Object value = mapEntry.getValue();
            SerializationHelper.serialize((EncodingTokenWriter)dataWriter, value, null, (SerializationContext)context);
            dataWriter.writeStructureEnd();
            context.leave(itemState);
        }
        context.leave(state);
        dataWriter.writeStructureEnd();
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Member m = context.getCurrentMember();
        if (context.registerReference(data, m.getType()) == null) {
            Map dataMap = (Map)data;
            Iterator it = dataMap.entrySet().iterator();
            SchemaContext.State state = context.enterCurrentMember();
            Member nextMember = context.nextMember();
            while (it.hasNext()) {
                Map.Entry mapEntry = it.next();
                SchemaContext.State internalState = context.enterCurrentMember();
                nextMember = context.nextMember();
                Object key = mapEntry.getKey();
                SerializationHelper.grabReferences(key, (SerializationContext)context);
                Object value = mapEntry.getValue();
                SerializationHelper.grabReferences(value, (SerializationContext)context);
                context.leave(internalState);
            }
            context.leave(state);
        }
    }

    protected void setStructParams(String structNamespace, String structName) {
        this.structType = new QName(structNamespace, structName);
    }

    public void init(Configurable config) {
    }
}

