/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.attachments;

import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLAttachmentSerializer
implements XMLSerializer {
    private static final QName REF_LOCATION = new QName("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location");

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            MessageAttachment d = (MessageAttachment)data;
            String contentLocation = d.getContentLocation();
            String reference = contentLocation != null ? contentLocation : "cid:" + d.getContentId();
            context.registerAttachment(d);
            boolean dime = false;
            Attribute[] attributes = context.getCurrentConstructSchemaType().getAttributes();
            if (attributes != null) {
                int i = 0;
                while (i < attributes.length) {
                    Attribute attribute = XMLSchemaUtil.dereferenceAttribute((Attribute)attributes[i]);
                    if (attribute != null && REF_LOCATION.equals(attribute.getName())) {
                        dime = true;
                        break;
                    }
                    ++i;
                }
            }
            if (dime) {
                SerializationHelper.writeDimeReference((TokenWriter)dataWriter, (QName)context.getCurrentConstructName(), (String)reference);
            } else {
                SerializationHelper.writeReference((TokenWriter)dataWriter, (QName)context.getCurrentConstructName(), (String)reference);
            }
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

