/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.EnumHelper;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.SerializationChainImpl;
import com.idoox.wasp.serialization.SerializationException;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaHolder;
import org.idoox.xml.schema.SimpleTypeEnumExtension;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class ReflectionSerializer
implements Serializer {
    static /* synthetic */ Class class$java$lang$Object;

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        this.serializeViaSchema(dataWriter, data, arrayPos, context, chain);
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        this.grabReferencesViaSchema(data, context, chain);
    }

    protected void serializeViaSchema(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Member m = context.getCurrentMember();
            String idString = context.getMultirefId(data);
            Type type = m.getType();
            if (type == null) {
                throw new SerializationException("Can not serialize unknown type of member " + m);
            }
            switch (type.getKind()) {
                case 20: {
                    SimpleTypeEnumExtension ext = (SimpleTypeEnumExtension)type.getExtension("SimpleTypeEnumExtension");
                    String enumField = EnumHelper.getEnumField((Object)data);
                    String value = ext.getXMLValue(enumField);
                    dataWriter.writePrimitive(m.getName(), type.getName(), value, arrayPos, idString);
                    break;
                }
                case 17: {
                    dataWriter.writePrimitive(m.getName(), type.getName(), this.getListValue(data), arrayPos, idString);
                    break;
                }
                case 16: {
                    if (data instanceof QName) {
                        dataWriter.writeQName(m.getName(), type.getName(), (QName)data, arrayPos, idString);
                        break;
                    }
                    dataWriter.writePrimitive(m.getName(), type.getName(), PrimitiveTypeAccessor.writePrimitiveObject((Object)data), arrayPos, idString);
                    break;
                }
                case 33: {
                    dataWriter.writeStructureStart(m.getName(), type.getName(), arrayPos, idString);
                    Map props = WaspSerializationHelper.getProperties(data.getClass());
                    SchemaContext.State state = context.enterCurrentMember();
                    Member childMember = context.nextMember();
                    while (childMember != null) {
                        Object memberObject;
                        String mName = WaspSerializationHelper.getConstructJavaMemberName((SchemaConstruct)childMember);
                        Object fieldOrMethod = props.get(mName);
                        if (fieldOrMethod == null) {
                            fieldOrMethod = props.get(WaspSerializationHelper.mapElementName((String)mName));
                            if (fieldOrMethod == null && !((fieldOrMethod = props.get(WaspSerializationHelper.decapitalizeName((String)mName))) instanceof PropertyDescriptor)) {
                                fieldOrMethod = null;
                            }
                            if (fieldOrMethod == null) {
                                throw new SerializationException("Member " + childMember + " not found within " + data.getClass());
                            }
                        }
                        if (fieldOrMethod instanceof PropertyDescriptor) {
                            PropertyDescriptor pd = (PropertyDescriptor)fieldOrMethod;
                            Method readMethod = pd.getReadMethod();
                            if (readMethod == null) {
                                throw new SerializationException("Don't have access to a read method for property " + childMember + " in " + data.getClass());
                            }
                            memberObject = readMethod.invoke(data, new Object[0]);
                        } else {
                            memberObject = WaspSerializationHelper.getField((Object)data, (Field)((Field)fieldOrMethod));
                        }
                        childMember = SerializationHelper.serialize((EncodingTokenWriter)dataWriter, (Object)memberObject, null, (SerializationContext)context);
                    }
                    context.leave(state);
                    dataWriter.writeStructureEnd();
                    break;
                }
                case 34: {
                    int dims = context.getCurrentMember().getType().getDimensions();
                    SchemaContext.State state = context.enterCurrentMember();
                    Member arrayMember = context.nextMember();
                    int[] size = new int[dims];
                    Object d = data;
                    int i = 0;
                    while (i < dims) {
                        size[i] = d == null ? 0 : Array.getLength(d);
                        d = d == null || Array.getLength(d) == 0 ? null : Array.get(d, 0);
                        ++i;
                    }
                    Type arrayMemberType = arrayMember.getType();
                    if (arrayMemberType == null) {
                        throw new SerializationException("Can not serialize arrays of unknown type");
                    }
                    dataWriter.writeArrayStart(m.getName(), arrayMemberType.getName(), size, arrayPos, idString);
                    context.leave(state);
                    this.writeArray(dataWriter, data, arrayPos, size, 0, context);
                    dataWriter.writeArrayEnd();
                    break;
                }
                case 37: {
                    Type t = (Type)type.clone();
                    t.setKind((short)33);
                    Member nm = new Member(m.getName(), t, true);
                    SchemaContext.State state = context.putMember(nm);
                    this.serialize(dataWriter, data, arrayPos, context, chain);
                    context.leave(state);
                    break;
                }
                case 35: {
                    if (XMLSchemaUtil.isArray((Type)type)) {
                        Member nm = this.createArrayMember(m.getName(), type, (SchemaHolder)context.getSchema());
                        SchemaContext.State state = context.putMember(nm);
                        this.serialize(dataWriter, data, arrayPos, context, chain);
                        context.leave(state);
                        break;
                    }
                    Type t = (Type)type.clone();
                    t.setKind((short)33);
                    Member nm = new Member(m.getName(), t, true);
                    SchemaContext.State state = context.putMember(nm);
                    this.serialize(dataWriter, data, arrayPos, context, chain);
                    context.leave(state);
                    break;
                }
                default: {
                    throw new SerializationException("Serialization of " + type.toString() + " not supported");
                }
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private void writeArray(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, int[] size, int dimension, SerializationContext context) throws MessageCreatingException {
        try {
            int n = size.length;
            if (dimension == n - 1) {
                SchemaContext.State state = context.enterCurrentMember();
                context.nextSchemaConstruct();
                SerializationChain chain = null;
                Serializer serializer = null;
                Class previousObjectClass = null;
                boolean referencingMultirefs = !context.isSerializingMultirefs();
                boolean multirefsNotInline = !context.isMultirefsInline();
                int i = 0;
                while (i < size[dimension]) {
                    if (data == null) {
                        dataWriter.writeNil(context.getCurrentConstructName(), arrayPos);
                    } else {
                        String ref;
                        Object object = Array.get(data, i);
                        if (referencingMultirefs && object != null && (multirefsNotInline || context.isReferenceSerialized(object)) && (ref = context.getMultirefRef(object)) != null) {
                            dataWriter.writeReference(context.getCurrentConstructName(), null, ref);
                        } else {
                            Class objectClass;
                            Class clazz = object != null ? object.getClass() : (objectClass = class$java$lang$Object == null ? ReflectionSerializer.class$("java.lang.Object") : class$java$lang$Object);
                            if (objectClass != previousObjectClass || chain == null) {
                                if (chain != null) {
                                    context.releaseSerializationChain(chain);
                                }
                                chain = context.getSerializationChain(objectClass);
                                serializer = (Serializer)chain.getNextSerializerAs(Serializer.MECHANISM_TYPE);
                                previousObjectClass = objectClass;
                            }
                            int chainState = ((SerializationChainImpl)chain).getSerializerState();
                            serializer.serialize(dataWriter, object, null, context, chain);
                            ((SerializationChainImpl)chain).setSerializerState(chainState);
                        }
                    }
                    ++i;
                }
                if (chain != null) {
                    context.releaseSerializationChain(chain);
                }
                context.leave(state);
            } else {
                int i = 0;
                while (i < size[dimension]) {
                    this.writeArray(dataWriter, Array.get(data, i), arrayPos, size, dimension + 1, context);
                    ++i;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            throw new MessageCreatingException("All array dimensions must match prescribed size, i.e all arrays in array ([][]) must have the same size.", (Throwable)aie);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void init(Configurable config) {
    }

    protected void grabReferencesViaSchema(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Type type = context.getCurrentConstructSchemaType();
            if (type == null) {
                throw new SerializationException("Can not serialize unknown type of member " + context.getCurrentMember());
            }
            switch (type.getKind()) {
                case 20: {
                    break;
                }
                case 16: 
                case 17: {
                    if (!PrimitiveTypeAccessor.isJavaLiteralType(data.getClass())) {
                        context.registerReference(data, type);
                    }
                    break;
                }
                case 33: {
                    if (context.registerReference(data, type) == null) {
                        Map props = WaspSerializationHelper.getProperties(data.getClass());
                        SchemaContext.State state = context.enterCurrentMember();
                        Member childMember = context.nextMember();
                        while (childMember != null) {
                            Object memberObject;
                            Object fieldOrMethod = props.get(childMember.getName().getLocalPart());
                            if (fieldOrMethod == null) {
                                fieldOrMethod = props.get(WaspSerializationHelper.mapElementName((String)childMember.getName().getLocalPart()));
                                if (fieldOrMethod == null && !((fieldOrMethod = props.get(WaspSerializationHelper.decapitalizeName((String)childMember.getName().getLocalPart()))) instanceof PropertyDescriptor)) {
                                    fieldOrMethod = null;
                                }
                                if (fieldOrMethod == null) {
                                    throw new SerializationException("Member " + childMember + " not found in " + data.getClass());
                                }
                            }
                            if (fieldOrMethod instanceof PropertyDescriptor) {
                                PropertyDescriptor pd = (PropertyDescriptor)fieldOrMethod;
                                Method readMethod = pd.getReadMethod();
                                if (readMethod == null) {
                                    throw new SerializationException("Don't have access to a read method for property " + childMember + " in " + data.getClass());
                                }
                                memberObject = readMethod.invoke(data, new Object[0]);
                            } else {
                                memberObject = WaspSerializationHelper.getField((Object)data, (Field)((Field)fieldOrMethod));
                            }
                            SerializationHelper.grabReferences((Object)memberObject, (SerializationContext)context);
                            childMember = context.getCurrentMember();
                        }
                        context.leave(state);
                    }
                    break;
                }
                case 34: {
                    if (context.registerReference(data, type) == null) {
                        if (!data.getClass().isArray()) {
                            throw new MessageCreatingException("Class " + data.getClass() + " is not an array");
                        }
                        this.grabArray(data, context, type.getDimensions());
                    }
                    break;
                }
                case 37: {
                    Type t = (Type)type.clone();
                    t.setKind((short)33);
                    Member nm = new Member(context.getCurrentConstructName(), t);
                    SchemaContext.State state = context.putMember(nm);
                    this.grabReferences(data, context, chain);
                    context.leave(state);
                    break;
                }
                case 35: {
                    if (XMLSchemaUtil.isArray((Type)type)) {
                        Member nm = this.createArrayMember(context.getCurrentConstructName(), type, (SchemaHolder)context.getSchema());
                        SchemaContext.State state = context.putMember(nm);
                        this.grabReferences(data, context, chain);
                        context.leave(state);
                        break;
                    }
                    Type t = (Type)type.clone();
                    t.setKind((short)33);
                    Member nm = new Member(context.getCurrentConstructName(), t);
                    SchemaContext.State state = context.putMember(nm);
                    this.grabReferences(data, context, chain);
                    context.leave(state);
                    break;
                }
                default: {
                    throw new SerializationException("Serialization of " + type.toIndentedString(0, new HashSet()) + " not supported");
                }
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private Member createArrayMember(QName name, Type type, SchemaHolder schema) throws SchemaException {
        Type t = (Type)type.clone();
        Member m = new Member(name, t, true);
        t.setKind((short)34);
        t.setDimensions(XMLSchemaUtil.getArrayDimensions((SchemaHolder)schema, (Type)type));
        Type ltype = XMLSchemaUtil.getArrayMemberType((SchemaHolder)schema, (Type)type);
        t.setSubconstructs((SchemaConstruct[])new Member[]{new Member(new QName(null, "item"), ltype, true)});
        return m;
    }

    private void grabArray(Object data, SerializationContext context, int dimensions) throws MessageCreatingException {
        if (data == null) {
            return;
        }
        int n = Array.getLength(data);
        if (dimensions == 1) {
            SchemaContext.State state = context.enterCurrentMember();
            context.nextSchemaConstruct();
            SerializationChain chain = null;
            XMLSerializer serializer = null;
            Class<?> previousValueClass = null;
            int i = 0;
            while (i < n) {
                Class<?> valueClass;
                Object value = Array.get(data, i);
                if (value != null && context.getMultirefId(value) == null && !PrimitiveTypeAccessor.isJavaLiteralType(valueClass = value.getClass())) {
                    if (valueClass != previousValueClass || chain == null) {
                        if (chain != null) {
                            context.releaseSerializationChain(chain);
                        }
                        chain = context.getSerializationChain(valueClass);
                        serializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                        previousValueClass = valueClass;
                    }
                    int chainState = ((SerializationChainImpl)chain).getSerializerState();
                    serializer.grabReferences(value, context, chain);
                    ((SerializationChainImpl)chain).setSerializerState(chainState);
                }
                ++i;
            }
            if (chain != null) {
                context.releaseSerializationChain(chain);
            }
            context.leave(state);
        } else {
            int subDim = dimensions - 1;
            int i = 0;
            while (i < n) {
                this.grabArray(Array.get(data, i), context, subDim);
                ++i;
            }
        }
    }

    private String getListValue(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        int len = Array.getLength(data);
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                ret.append(' ');
            }
            ret.append(Array.get(data, i));
            ++i;
        }
        return ret.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

