/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.SerializationHelper;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementSerializer
implements Serializer {
    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Element element;
            if (data instanceof Document) {
                element = ((Document)data).getDocumentElement();
            } else if (data instanceof Element) {
                element = (Element)data;
            } else {
                throw new MessageCreatingException("Serialization is not suported for a DOM class " + data.getClass().getName());
            }
            boolean isAnyComplexType = SerializationHelper.isAnyComplexType((SchemaContext)context);
            if (element == null) {
                if (isAnyComplexType) {
                    dataWriter.writeNil(context.getCurrentConstructName(), arrayPos);
                    return;
                }
                throw new MessageCreatingException("Sending Document with <null> root element is not allowed");
            }
            if (isAnyComplexType) {
                QName name = context.getCurrentConstructName();
                QName typeName = context.getCurrentConstructSchemaType().getName();
                dataWriter.writeStructureStart(name, typeName, null, null);
            }
            dataWriter.writeElement(element);
            if (isAnyComplexType) {
                dataWriter.writeStructureEnd();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
    }

    public void init(Configurable conf) {
    }
}

