/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.debug.Category;
import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.HolderReference;
import com.idoox.wasp.serialization.PolymorphismHelper;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import java.lang.reflect.Array;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.TopLevelReferenceHolder;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;

public class BasicConstructDeserializer
implements org.idoox.wasp.serialization.Deserializer {
    private static final Category cat = Category.getCategory((String)"com.idoox.wasp.serialization.BasicConstructDeserializer");
    PolymorphismHelper helper = new PolymorphismHelper();
    static /* synthetic */ Class class$java$lang$Object;

    public Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            int token = dataTokenizer.getCurrentToken();
            String id = dataTokenizer.getID();
            if (token == 6) {
                if (id != null) {
                    context.setReferencedValue(id, null);
                }
                return null;
            }
            if (token == 5) {
                TopLevelReferenceHolder holder = new TopLevelReferenceHolder(targetClass, context.getCurrentConstructSchemaType());
                String ref = dataTokenizer.getReference();
                context.addReference(ref, (Reference)new HolderReference((Object)holder, context.getCurrentConstructSchemaType()));
                if (id != null) {
                    throw new DeserializationException("Can not process both id & ref on one element");
                }
                return holder;
            }
            boolean releaseChain = false;
            Class polymorphicTargetClass = null;
            String typeName = dataTokenizer.getTokenTypeName();
            String typeNamespaceURI = dataTokenizer.getTokenTypeNamespaceURI();
            if (typeName != null) {
                if (token != 3) {
                    boolean typeDiffers = false;
                    Type currentType = context.getCurrentConstructSchemaType();
                    QName currentTypeName = currentType.getName();
                    if (currentTypeName != null) {
                        if (!currentTypeName.getLocalPart().equals(typeName) || !currentTypeName.getNamespaceURI().equals(typeNamespaceURI)) {
                            typeDiffers = true;
                        }
                    } else {
                        typeDiffers = true;
                    }
                    if (typeDiffers) {
                        QName typeQName = new QName(typeNamespaceURI, typeName);
                        Type type = null;
                        if (!"http://idoox.com/package/".equals(typeNamespaceURI)) {
                            type = context.getSchemaType(typeQName);
                        }
                        if (type == null && (type = this.helper.getGeneratedSchemaType(context, typeQName)) == null) {
                            throw new MessageProcessingException("Don'currentType have type representation for {" + typeNamespaceURI + "}" + typeName);
                        }
                        context.replaceTopMemberType(type);
                        currentType = type;
                        polymorphicTargetClass = BasicConstructDeserializer.getMappingFromTypeRepository(currentType, context);
                        if (polymorphicTargetClass == null && targetClass == (class$java$lang$Object == null ? (class$java$lang$Object = BasicConstructDeserializer.class$("java.lang.Object")) : class$java$lang$Object)) {
                            QName n = currentType.getName();
                            polymorphicTargetClass = BasicConstructDeserializer.getIdooxMappingClass(n.getNamespaceURI(), n.getLocalPart(), context);
                        }
                    }
                } else {
                    Type currentType;
                    polymorphicTargetClass = BasicConstructDeserializer.getArrayClass(dataTokenizer.getTokenTypeNamespaceURI(), dataTokenizer.getTokenTypeName(), dataTokenizer.getArrayDimensions(), context);
                    if (polymorphicTargetClass != null && polymorphicTargetClass != targetClass && targetClass.isAssignableFrom(polymorphicTargetClass) && (currentType = this.helper.getClassSchemaType(context, polymorphicTargetClass)) != null) {
                        context.replaceTopMemberType(currentType);
                    }
                }
            }
            if (polymorphicTargetClass != null && polymorphicTargetClass != targetClass && targetClass.isAssignableFrom(polymorphicTargetClass)) {
                targetClass = polymorphicTargetClass;
                chain = context.getDeserializationChain(targetClass);
                chain.removeDeserializer((Deserializer)this);
                releaseChain = true;
            } else {
                Type currentConstructSchemaType = context.getCurrentConstructSchemaType();
                String typeTargetClassName = context.getType(currentConstructSchemaType);
                if (typeTargetClassName != null && !targetClass.getName().equals(typeTargetClassName)) {
                    try {
                        QName name;
                        Class typeTargetClass = null;
                        if (PrimitiveTypeAccessor.isPrimitive((String)typeTargetClassName) && (name = currentConstructSchemaType.getName()) != null) {
                            typeTargetClass = PrimitiveTypeAccessor.getPrimitiveClass((String)name.getNamespaceURI(), (String)name.getLocalPart());
                        }
                        if (typeTargetClass == null) {
                            typeTargetClass = Class.forName(typeTargetClassName, true, context.getClassLoader());
                        }
                        if (targetClass.isAssignableFrom(typeTargetClass)) {
                            targetClass = typeTargetClass;
                            chain = context.getDeserializationChain(targetClass);
                            chain.removeDeserializer((Deserializer)this);
                            releaseChain = true;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new MessageProcessingException("Can't find class " + typeTargetClassName + " for deserialized type", (Throwable)e);
                    }
                }
            }
            org.idoox.wasp.serialization.Deserializer deserializer = (org.idoox.wasp.serialization.Deserializer)chain.getNextDeserializerAs(org.idoox.wasp.serialization.Deserializer.MECHANISM_TYPE);
            Object ret = deserializer.deserialize(dataTokenizer, targetClass, context, chain);
            if (releaseChain) {
                context.releaseDeserializationChain(chain);
            }
            if (id != null) {
                context.setReferencedValue(id, ret);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (SchemaException e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    private static Class getIdooxMappingClass(String typeNamespaceURI, String typeLocalPart, DeserializationContext ctx) {
        if ("http://idoox.com/package/".equals(typeNamespaceURI) && !typeLocalPart.startsWith("ArrayOf")) {
            try {
                return Class.forName(typeLocalPart, true, ctx.getClassLoader());
            }
            catch (Exception e) {
                cat.error("Class " + typeLocalPart + " has not been found");
            }
        }
        return null;
    }

    private static Class getArrayClass(String typeNamespaceURI, String typeName, int[] dims, DeserializationContext ctx) throws SchemaException {
        Class ret = BasicConstructDeserializer.getArrayComponentClass(typeNamespaceURI, typeName, ctx);
        if (ret != null) {
            return BasicConstructDeserializer.getArrayClass(ret, dims);
        }
        return null;
    }

    public static Class getArrayComponentClass(String typeNamespaceURI, String typeName, DeserializationContext ctx) throws SchemaException {
        Class ret = BasicConstructDeserializer.getIdooxMappingClass(typeNamespaceURI, typeName, ctx);
        if (ret != null) {
            return ret;
        }
        QName type = new QName(typeNamespaceURI, typeName);
        String typeNameString = ctx.getType(ctx.getSchemaType(type));
        if (typeNameString != null) {
            ret = BasicConstructDeserializer.getTypeClass(typeNamespaceURI, typeName, typeNameString, ctx);
            return ret;
        }
        return null;
    }

    private static Class getArrayClass(Class cls, int[] dims) {
        int i = 0;
        while (i < dims.length) {
            cls = Array.newInstance(cls, 0).getClass();
            ++i;
        }
        return cls;
    }

    private static Class getMappingFromTypeRepository(Type type, DeserializationContext ctx) throws SchemaException {
        block4: {
            QName typeName = type.getName();
            String typeMappingClassName = ctx.getType(type);
            if (typeMappingClassName != null) {
                try {
                    if (PrimitiveTypeAccessor.isPrimitive((String)typeMappingClassName) && typeName != null) {
                        return PrimitiveTypeAccessor.getPrimitiveClass((String)typeName.getNamespaceURI(), (String)typeName.getLocalPart());
                    }
                    return Class.forName(typeMappingClassName, true, ctx.getClassLoader());
                }
                catch (Exception e) {
                    if (!cat.isDebugEnabled()) break block4;
                    cat.debug("Class " + typeMappingClassName + " has not been found");
                }
            }
        }
        return null;
    }

    private static Class getTypeClass(String typeNamespaceURI, String typeName, String name, DeserializationContext ctx) {
        try {
            Class ret = PrimitiveTypeAccessor.getPrimitiveArrayClass((String)typeName, (String)typeNamespaceURI);
            if (ret != null) {
                return ret;
            }
            return Class.forName(name, true, ctx.getClassLoader());
        }
        catch (Exception e) {
            cat.error("", (Throwable)e);
            return null;
        }
    }

    public String getMechanismType() {
        return org.idoox.wasp.serialization.Deserializer.MECHANISM_TYPE;
    }

    public void init(Configurable conf) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

