/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.validator.serialization;

import com.idoox.debug.Category;
import com.systinet.wasp.validator.serialization.ProxyDeSerializerHelper;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.MessageProcessingException;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.xml.schema.validation.ValidationConfig;

public class ValidatingDeserializerProxy
implements XMLDeserializer {
    private static final Category dbg = Category.getCategory((String)"com.systinet.wasp.validator.serialization.ValidatingDeserializerProxy");
    private static Map configCache = Collections.synchronizedMap(new WeakHashMap());
    private static XMLDeserializer validatingDS;

    private ValidationConfig getCurrentValidationConfig() {
        ValidationConfig retVal;
        if (Current.getProcessingType() == 2) {
            ServiceEndpointContext sec = Current.getServiceEndpointContext();
            retVal = (ValidationConfig)configCache.get(sec);
            if (retVal != null) {
                return retVal;
            }
            retVal = ProxyDeSerializerHelper.getValidationConfig(sec);
            configCache.put(sec, retVal);
        } else {
            ServiceClientContext scc = Current.getServiceClientContext();
            retVal = (ValidationConfig)configCache.get(scc);
            if (retVal != null) {
                return retVal;
            }
            retVal = ProxyDeSerializerHelper.getValidationConfig(scc);
            configCache.put(scc, retVal);
        }
        return retVal;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        ValidationConfig vCfg = this.getCurrentValidationConfig();
        if ((vCfg.getDirection() & 1) != 0) {
            if (validatingDS != null) {
                return validatingDS.deserialize(dataTokenizer, currentToken, targetClass, context, chain);
            }
            dbg.error("validation desired but validator unavailable: check your installation");
        }
        XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
        return deserializer.deserialize(dataTokenizer, currentToken, targetClass, context, chain);
    }

    public void init(Configurable configurable) {
        validatingDS = ProxyDeSerializerHelper.createValidatingDeserializer();
        if (validatingDS != null) {
            validatingDS.init(configurable);
        }
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

