/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.validator.serialization;

import com.systinet.wasp.validator.serialization.ValidationConfigHelper;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.wasp.serialization.XMLSerializer;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.xml.schema.validation.ValidationConfig;

public class ProxyDeSerializerHelper {
    public static XMLDeserializer createValidatingDeserializer() {
        return (XMLDeserializer)ProxyDeSerializerHelper.safeCreateClass("com.systinet.wasp.validator.serialization.ValidatingDeserializer");
    }

    public static XMLSerializer createValidatingSerializer() {
        return (XMLSerializer)ProxyDeSerializerHelper.safeCreateClass("com.systinet.wasp.validator.serialization.ValidatingSerializer");
    }

    public static ValidationConfig getValidationConfig(ServiceEndpointContext endpointContext) {
        ValidationConfig vc = null;
        if (endpointContext != null && (vc = ProxyDeSerializerHelper.getValidationConfig4Context(endpointContext)) == null) {
            vc = ValidationConfigHelper.getDDValidationConfig(endpointContext.getServiceEndpoint());
        }
        if (vc == null) {
            vc = ValidationConfigHelper.getDefaultServerConfig();
        }
        if (endpointContext != null) {
            endpointContext.getContextData().put("validation.config.key", vc);
        }
        return vc;
    }

    public static ValidationConfig getValidationConfig(ServiceClientContext clientContext) {
        ValidationConfig vc = null;
        if (clientContext != null && (vc = ProxyDeSerializerHelper.getValidationConfig4Context(clientContext)) == null) {
            vc = ValidationConfigHelper.getDDValidationConfig(clientContext.getServiceClient());
        }
        if (vc == null) {
            vc = ValidationConfigHelper.getDefaultClientConfig();
        }
        if (clientContext != null) {
            clientContext.getContextData().put("validation.config.key", vc);
        }
        return vc;
    }

    public static ValidationConfig getValidationConfig() {
        ValidationConfig retVal = Current.getProcessingType() == 2 ? ProxyDeSerializerHelper.getValidationConfig(Current.getServiceEndpointContext()) : ProxyDeSerializerHelper.getValidationConfig(Current.getServiceClientContext());
        return retVal;
    }

    private static ValidationConfig getValidationConfig4Context(ServiceEndpointContext sec) {
        return (ValidationConfig)sec.getContextData().get("validation.config.key");
    }

    private static ValidationConfig getValidationConfig4Context(ServiceClientContext scc) {
        return (ValidationConfig)scc.getContextData().get("validation.config.key");
    }

    private static Object safeCreateClass(String classname) {
        try {
            return Class.forName(classname).newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

