/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.xml.XMLAttributesSerializationHelper;
import com.idoox.wasp.serialization.xml.msnet.XMLCollectionSerializer;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLMapSerializer
implements XMLSerializer {
    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            Type currentType = context.getCurrentConstructSchemaType();
            QName memberQName = null;
            String prefix = null;
            Map map = (Map)data;
            int i = map.size();
            Object[] arrayOfKeys = new Object[i];
            Object[] arrayOfValues = new Object[i];
            i = 0;
            Iterator entryIter = map.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                arrayOfKeys[i] = entry.getKey();
                arrayOfValues[i] = entry.getValue();
                ++i;
            }
            SchemaConstruct schemaConstruct = context.getCurrentSchemaConstruct();
            if (schemaConstruct.getConstructType() != SchemaConstruct.ConstructType.MEMBER) {
                throw new MessageCreatingException("Only elements are supported in XML serialization.");
            }
            Member mapMember = (Member)schemaConstruct;
            memberQName = mapMember.getName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            QName schemaTypeQName = mapMember.getType().getName();
            prefix = dataWriter.getPrefixForNamespace(schemaTypeQName.getNamespaceURI());
            if (prefix == null) {
                prefix = "msn";
                dataWriter.setPrefixForNamespace(prefix, schemaTypeQName.getNamespaceURI());
            }
            dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + schemaTypeQName.getLocalPart());
            XMLAttributesSerializationHelper.writeAttributes(dataWriter, data, context, next, currentType);
            SchemaContext.State mapState = context.enterCurrentMember();
            context.nextMember();
            this.serializeArray(dataWriter, arrayOfKeys, context, next);
            this.serializeArray(dataWriter, arrayOfValues, context, next);
            context.leave(mapState);
            XMLCollectionSerializer.serializeCustomProperties(dataWriter, data, context, next, currentType);
            dataWriter.leave();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    protected void serializeArray(TokenWriter dataWriter, Object[] data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            QName memberQName = context.getCurrentConstructName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            SchemaContext.State arrayState = context.enterCurrentMember();
            Member member = context.nextMember();
            Member fakeMember = new Member(member.getName(), member.getType(), true);
            int i = 0;
            while (i < data.length) {
                SchemaContext.State itemState = context.putSchemaConstruct((SchemaConstruct)fakeMember);
                SerializationHelper.serialize((TokenWriter)dataWriter, (Object)data[i], (SerializationContext)context);
                context.leave(itemState);
                ++i;
            }
            context.leave(arrayState);
            dataWriter.leave();
            context.nextSchemaConstruct();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException("Exception occured while serializing Map", (Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        SchemaContext.State entryState;
        SchemaContext.State mapState;
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, member.getType()) == null) {
            SchemaContext.State itemState;
            Map.Entry entry;
            Map map = (Map)data;
            mapState = context.enterCurrentMember();
            context.nextMember();
            entryState = context.enterCurrentMember();
            member = context.nextMember();
            Iterator entryIterator = map.entrySet().iterator();
            while (entryIterator.hasNext()) {
                entry = entryIterator.next();
                itemState = context.putSchemaConstruct((SchemaConstruct)member);
                SerializationHelper.grabReferences(entry.getKey(), (SerializationContext)context);
                context.leave(itemState);
            }
            context.leave(entryState);
            context.nextMember();
            entryState = context.enterCurrentMember();
            member = context.nextMember();
            entryIterator = map.entrySet().iterator();
            while (entryIterator.hasNext()) {
                entry = entryIterator.next();
                itemState = context.putSchemaConstruct((SchemaConstruct)member);
                SerializationHelper.grabReferences(entry.getValue(), (SerializationContext)context);
                context.leave(itemState);
            }
        } else {
            throw new MessageCreatingException("In document/literal it is not allowed to have multireferences. Data already registered: " + data.getClass().getName());
        }
        context.leave(entryState);
        context.leave(mapState);
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

