/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.SerializationHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xmlrpc.MessageProcessingException;

public final class XMLSimpleDeserializer
implements XMLDeserializer {
    private static QName booleanQName = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    private static QName byteQName = new QName("http://www.w3.org/2001/XMLSchema", "byte");
    private static QName doubleQName = new QName("http://www.w3.org/2001/XMLSchema", "double");
    private static QName floatQName = new QName("http://www.w3.org/2001/XMLSchema", "float");
    private static QName integerQName = new QName("http://www.w3.org/2001/XMLSchema", "int");
    private static QName longQName = new QName("http://www.w3.org/2001/XMLSchema", "long");
    private static QName shortQName = new QName("http://www.w3.org/2001/XMLSchema", "short");
    private static QName stringQName = new QName("http://www.w3.org/2001/XMLSchema", "string");
    private static Set schemaPrimitives = new HashSet(29);
    private static Map primitives = new HashMap(29);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            if (context.getCurrentConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                Simple simpleSerializer;
                QName xsiType = SerializationHelper.getXsiType((Tokenizer)dataTokenizer, (Token)currentToken);
                if (xsiType == null) {
                    xsiType = context.getCurrentConstructSchemaType().getName();
                }
                if (schemaPrimitives.contains(xsiType) && (simpleSerializer = (Simple)primitives.get(targetClass)) != null) {
                    Object toRet;
                    dataTokenizer.readToken(currentToken);
                    if (SerializationHelper.isNil((Token)currentToken)) {
                        SerializationHelper.assertCanBeNil((SchemaConstruct)context.getCurrentSchemaConstruct(), (Token)currentToken);
                        dataTokenizer.next();
                        return null;
                    }
                    byte state = dataTokenizer.next();
                    if (state == 4) {
                        toRet = simpleSerializer.deserialize(dataTokenizer.readContent());
                        dataTokenizer.next();
                    } else if (state == 3) {
                        toRet = simpleSerializer.deserialize("");
                    } else {
                        throw new MessageProcessingException("Bad message : expected text, got start of element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                    }
                    return toRet;
                }
            }
            XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
            return deserializer.deserialize(dataTokenizer, currentToken, targetClass, context, chain);
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = XMLSimpleDeserializer.class$("java.lang.Boolean")) : class$java$lang$Boolean, new SimpleBoolean());
        primitives.put(class$java$lang$Byte == null ? (class$java$lang$Byte = XMLSimpleDeserializer.class$("java.lang.Byte")) : class$java$lang$Byte, new SimpleByte());
        primitives.put(class$java$lang$Character == null ? (class$java$lang$Character = XMLSimpleDeserializer.class$("java.lang.Character")) : class$java$lang$Character, new SimpleCharacter());
        primitives.put(class$java$lang$Double == null ? (class$java$lang$Double = XMLSimpleDeserializer.class$("java.lang.Double")) : class$java$lang$Double, new SimpleDouble());
        primitives.put(class$java$lang$Float == null ? (class$java$lang$Float = XMLSimpleDeserializer.class$("java.lang.Float")) : class$java$lang$Float, new SimpleFloat());
        primitives.put(class$java$lang$Integer == null ? (class$java$lang$Integer = XMLSimpleDeserializer.class$("java.lang.Integer")) : class$java$lang$Integer, new SimpleInteger());
        primitives.put(class$java$lang$Long == null ? (class$java$lang$Long = XMLSimpleDeserializer.class$("java.lang.Long")) : class$java$lang$Long, new SimpleLong());
        primitives.put(class$java$lang$Short == null ? (class$java$lang$Short = XMLSimpleDeserializer.class$("java.lang.Short")) : class$java$lang$Short, new SimpleShort());
        primitives.put(class$java$lang$String == null ? (class$java$lang$String = XMLSimpleDeserializer.class$("java.lang.String")) : class$java$lang$String, new SimpleString());
        schemaPrimitives.add(booleanQName);
        schemaPrimitives.add(byteQName);
        schemaPrimitives.add(doubleQName);
        schemaPrimitives.add(floatQName);
        schemaPrimitives.add(integerQName);
        schemaPrimitives.add(longQName);
        schemaPrimitives.add(shortQName);
        schemaPrimitives.add(stringQName);
    }

    private static class SimpleString
    implements Simple {
        private SimpleString() {
        }

        public Object deserialize(String s) {
            return s;
        }
    }

    private static class SimpleShort
    implements Simple {
        private SimpleShort() {
        }

        public Object deserialize(String s) {
            return Short.valueOf(s);
        }
    }

    private static class SimpleLong
    implements Simple {
        private SimpleLong() {
        }

        public Object deserialize(String s) {
            return Long.valueOf(s);
        }
    }

    private static class SimpleInteger
    implements Simple {
        private SimpleInteger() {
        }

        public Object deserialize(String s) {
            return Integer.valueOf(s);
        }
    }

    private static class SimpleFloat
    implements Simple {
        private SimpleFloat() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if (s.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                return new Float(Float.NaN);
            }
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected float value : " + s, (Throwable)e);
            }
        }
    }

    private static class SimpleDouble
    implements Simple {
        private SimpleDouble() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if (s.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                return new Double(Double.NaN);
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected double value : " + s, (Throwable)e);
            }
        }
    }

    private static class SimpleCharacter
    implements Simple {
        private SimpleCharacter() {
        }

        public Object deserialize(String s) {
            if (s == null || s.length() == 0) {
                return new Character('\u0000');
            }
            return new Character(s.charAt(0));
        }
    }

    private static class SimpleByte
    implements Simple {
        private SimpleByte() {
        }

        public Object deserialize(String s) throws DeserializationException {
            return Byte.valueOf(s);
        }
    }

    private static class SimpleBoolean
    implements Simple {
        private SimpleBoolean() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if ("true".equals(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equals(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
            throw new DeserializationException("Unexpected boolean value : " + s);
        }
    }

    private static interface Simple {
        public Object deserialize(String var1) throws DeserializationException;
    }
}

