/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.javabuiltin.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class MapSerializer
implements Serializer {
    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Map map = (Map)data;
            int i = map.size();
            Object[] arrayOfKeys = new Object[i];
            Object[] arrayOfValues = new Object[i];
            i = 0;
            Iterator entryIter = map.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry entry = entryIter.next();
                arrayOfKeys[i] = entry.getKey();
                arrayOfValues[i] = entry.getValue();
                ++i;
            }
            Member member = (Member)context.getCurrentSchemaConstruct();
            dataWriter.writeStructureStart(member.getName(), member.getType().getName(), arrayPos, context.getMultirefId(data));
            SchemaContext.State mapState = context.enterCurrentMember();
            member = context.nextMember();
            this.serializeArray(dataWriter, arrayOfKeys, arrayPos, context, chain);
            this.serializeArray(dataWriter, arrayOfValues, arrayPos, context, chain);
            context.leave(mapState);
            dataWriter.writeStructureEnd();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException("Exception occured while serializing Map structure", (Throwable)e);
        }
    }

    public void serializeArray(EncodingTokenWriter dataWriter, Object[] data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        QName memberQName = context.getCurrentConstructName();
        SchemaContext.State arrayState = context.enterCurrentMember();
        Member member = context.nextMember();
        dataWriter.writeArrayStart(memberQName, member.getType().getName(), new int[]{data.length}, arrayPos, null);
        Member fakeMember = new Member(member.getName(), member.getType(), true);
        int i = 0;
        while (i < data.length) {
            SchemaContext.State itemState = context.putSchemaConstruct((SchemaConstruct)fakeMember);
            SerializationHelper.serialize((EncodingTokenWriter)dataWriter, (Object)data[i], (int[])arrayPos, (SerializationContext)context);
            context.leave(itemState);
            ++i;
        }
        dataWriter.writeArrayEnd();
        context.leave(arrayState);
        context.nextSchemaConstruct();
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, member.getType()) == null) {
            SchemaContext.State itemState;
            Map.Entry entry;
            Map map = (Map)data;
            SchemaContext.State mapState = context.enterCurrentMember();
            context.nextMember();
            SchemaContext.State entryState = context.enterCurrentMember();
            member = context.nextMember();
            Iterator entryIterator = map.entrySet().iterator();
            while (entryIterator.hasNext()) {
                entry = entryIterator.next();
                itemState = context.putSchemaConstruct((SchemaConstruct)member);
                SerializationHelper.grabReferences(entry.getKey(), (SerializationContext)context);
                context.leave(itemState);
            }
            context.leave(entryState);
            context.nextMember();
            entryState = context.enterCurrentMember();
            member = context.nextMember();
            entryIterator = map.entrySet().iterator();
            while (entryIterator.hasNext()) {
                entry = entryIterator.next();
                itemState = context.putSchemaConstruct((SchemaConstruct)member);
                SerializationHelper.grabReferences(entry.getValue(), (SerializationContext)context);
                context.leave(itemState);
            }
            context.leave(entryState);
            context.leave(mapState);
        }
    }

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void init(Configurable conf) {
    }
}

