/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.javabuiltin;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public abstract class EnumIterSerializer
implements Serializer {
    protected static Map cachedEnumIters = new HashMap();

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void init(Configurable configurable) {
    }

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        try {
            Member m = context.getCurrentMember();
            String id = context.getMultirefId(data);
            dataWriter.writeStructureStart(m.getName(), m.getType().getName(), arrayPos, id);
            SchemaContext.State state = context.enterCurrentMember();
            context.nextMember();
            Object[] objs = this.getAllFromCache(data);
            this.removeDataFromCache(data);
            SerializationHelper.serialize((EncodingTokenWriter)dataWriter, (Object)objs, null, (SerializationContext)context);
            context.leave(state);
            dataWriter.writeStructureEnd();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Member m = context.getCurrentMember();
        if (context.registerReference(data, m.getType()) == null) {
            while (this.hasNext(data)) {
                Object item = this.next(data);
                this.toCache(data, item);
            }
            this.listCacheToArray(data);
            SchemaContext.State state = context.enterCurrentMember();
            context.nextMember();
            SerializationHelper.grabReferences((Object)this.getAllFromCache(data), (SerializationContext)context);
            context.leave(state);
        }
    }

    protected abstract boolean hasNext(Object var1);

    protected abstract Object next(Object var1);

    private void listCacheToArray(Object data) {
        ArrayList cei = null;
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            cei = (ArrayList)cachedEnumIters.get(dataKey);
            cachedEnumIters.put(dataKey, cei.toArray());
        }
    }

    void removeDataFromCache(Object data) {
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            cachedEnumIters.remove(dataKey);
        }
    }

    Object[] getAllFromCache(Object data) {
        String dataKey = this.toHashCodeString(data);
        if (cachedEnumIters.containsKey(dataKey)) {
            Object[] ret = (Object[])cachedEnumIters.get(dataKey);
            return ret;
        }
        ArrayList<Object> al = new ArrayList<Object>();
        while (this.hasNext(data)) {
            Object item = this.next(data);
            al.add(item);
        }
        if (al.size() > 0) {
            return al.toArray();
        }
        return null;
    }

    private void toCache(Object data, Object item) {
        ArrayList cei = null;
        if (cachedEnumIters.containsKey(this.toHashCodeString(data))) {
            cei = (ArrayList)cachedEnumIters.get(this.toHashCodeString(data));
        } else {
            cei = new ArrayList();
            cachedEnumIters.put(this.toHashCodeString(data), cei);
        }
        cei.add(item);
    }

    private String toHashCodeString(Object data) {
        return data.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(data));
    }
}

