/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.DeserializationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;

public final class SimpleDeserializer
implements Deserializer {
    private static Set schemaPrimitives = new HashSet(29);
    private static Map primitives = new HashMap(29);
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            int token = dataTokenizer.getCurrentToken();
            if (token == 6) {
                String id = dataTokenizer.getID();
                if (id == null) return null;
                context.setReferencedValue(id, null);
                return null;
            }
            if (token != 5 && context.getCurrentConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                Simple simpleSerializer;
                QName typeQName;
                Type currentConstructSchemaType;
                String typeNamespace = dataTokenizer.getTokenTypeNamespaceURI();
                String typeName = dataTokenizer.getTokenTypeName();
                if (typeName == null && (currentConstructSchemaType = context.getCurrentConstructSchemaType()) != null && (typeQName = currentConstructSchemaType.getName()) != null) {
                    typeNamespace = typeQName.getNamespaceURI();
                    typeName = typeQName.getLocalPart();
                }
                if (typeName != null && "http://www.w3.org/2001/XMLSchema".equals(typeNamespace) && schemaPrimitives.contains(typeName) && (simpleSerializer = (Simple)primitives.get(targetClass)) != null) {
                    Object toRet;
                    String id = dataTokenizer.getID();
                    if (token == 4) {
                        toRet = simpleSerializer.deserialize(dataTokenizer.getPrimitiveTokenValue());
                    } else {
                        if (token != 1) throw new MessageProcessingException("Unexpected XML token: " + token + ", primitive content was expected instead");
                        if (dataTokenizer.next() != 2) throw new MessageProcessingException("Unexpected XML token: " + token + ", primitive content or ending token was expected instead");
                        toRet = simpleSerializer.deserialize("");
                    }
                    if (id == null) return toRet;
                    context.setReferencedValue(id, toRet);
                    return toRet;
                }
            }
            Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
            return deserializer.deserialize(dataTokenizer, targetClass, context, chain);
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return Deserializer.MECHANISM_TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitives.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleDeserializer.class$("java.lang.Boolean")) : class$java$lang$Boolean, new SimpleBoolean());
        primitives.put(class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleDeserializer.class$("java.lang.Byte")) : class$java$lang$Byte, new SimpleByte());
        primitives.put(class$java$lang$Character == null ? (class$java$lang$Character = SimpleDeserializer.class$("java.lang.Character")) : class$java$lang$Character, new SimpleCharacter());
        primitives.put(class$java$lang$Double == null ? (class$java$lang$Double = SimpleDeserializer.class$("java.lang.Double")) : class$java$lang$Double, new SimpleDouble());
        primitives.put(class$java$lang$Float == null ? (class$java$lang$Float = SimpleDeserializer.class$("java.lang.Float")) : class$java$lang$Float, new SimpleFloat());
        primitives.put(class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleDeserializer.class$("java.lang.Integer")) : class$java$lang$Integer, new SimpleInteger());
        primitives.put(class$java$lang$Long == null ? (class$java$lang$Long = SimpleDeserializer.class$("java.lang.Long")) : class$java$lang$Long, new SimpleLong());
        primitives.put(class$java$lang$Short == null ? (class$java$lang$Short = SimpleDeserializer.class$("java.lang.Short")) : class$java$lang$Short, new SimpleShort());
        primitives.put(class$java$lang$String == null ? (class$java$lang$String = SimpleDeserializer.class$("java.lang.String")) : class$java$lang$String, new SimpleString());
        schemaPrimitives.add("boolean");
        schemaPrimitives.add("byte");
        schemaPrimitives.add("double");
        schemaPrimitives.add("float");
        schemaPrimitives.add("int");
        schemaPrimitives.add("long");
        schemaPrimitives.add("short");
        schemaPrimitives.add("string");
    }

    private static class SimpleString
    implements Simple {
        private SimpleString() {
        }

        public Object deserialize(String s) {
            return s;
        }
    }

    private static class SimpleShort
    implements Simple {
        private SimpleShort() {
        }

        public Object deserialize(String s) {
            return Short.valueOf(s);
        }
    }

    private static class SimpleLong
    implements Simple {
        private SimpleLong() {
        }

        public Object deserialize(String s) {
            return Long.valueOf(s);
        }
    }

    private static class SimpleInteger
    implements Simple {
        private SimpleInteger() {
        }

        public Object deserialize(String s) {
            return Integer.valueOf(s);
        }
    }

    private static class SimpleFloat
    implements Simple {
        private SimpleFloat() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if (s.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                return new Float(Float.NaN);
            }
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected float value : " + s, (Throwable)e);
            }
        }
    }

    private static class SimpleDouble
    implements Simple {
        private SimpleDouble() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if (s.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                return new Double(Double.NaN);
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected double value : " + s, (Throwable)e);
            }
        }
    }

    private static class SimpleCharacter
    implements Simple {
        private SimpleCharacter() {
        }

        public Object deserialize(String s) {
            if (s == null || s.length() == 0) {
                return new Character('\u0000');
            }
            return new Character(s.charAt(0));
        }
    }

    private static class SimpleByte
    implements Simple {
        private SimpleByte() {
        }

        public Object deserialize(String s) throws DeserializationException {
            return Byte.valueOf(s);
        }
    }

    private static class SimpleBoolean
    implements Simple {
        private SimpleBoolean() {
        }

        public Object deserialize(String s) throws DeserializationException {
            if ("true".equals(s) || "1".equals(s)) {
                return Boolean.TRUE;
            }
            if ("false".equals(s) || "0".equals(s)) {
                return Boolean.FALSE;
            }
            throw new DeserializationException("Unexpected boolean value : " + s);
        }
    }

    private static interface Simple {
        public Object deserialize(String var1) throws DeserializationException;
    }
}

