(ns pallet.crate.package-builder
  "Build packages"
  (:require
   [pallet.resource.directory :as directory]
   [pallet.resource.exec-script :as exec-script]
   [pallet.resource.package :as package]
   [pallet.resource.remote-file :as remote-file]
   [pallet.stevedore :as stevedore]))

(defn rpmbuild-dirs
  [base]
  (concat
   [base]
   (map
    #(str base "/" %)
    ["BUILD" "RPMS" "SPECS" "SOURCES" "SRPMS"])))

;; http://wiki.centos.org/HowTos/SetupRpmBuildEnvironment

(defn yum-package-setup
  "Build a yum package"
  [request & {:keys [base-dir packager-name packager-email]
              :or {base-dir "$HOME/rpmbuild"
                   packager-name "Pallet package builder"
                   packager-email "none@nowhere.com"}}]
  (->
   request
   (package/package "rpm-build")
   (package/package "redhat-rpm-config")
   (directory/directories (rpmbuild-dirs base-dir))
   (remote-file/remote-file
    "$HOME/.rpmmacros"
    :content (format
              "%%_topdir %s\n%%packager %s <%s>"
              base-dir packager-name packager-email))))

(defn rpm-rebuild
  "Build a rpm src package"
  [request path]
  (->
   request
   (exec-script/exec-checked-script
    (format "rpmbuild %s" path)
    (cd $(basename ~path))
    (rpmbuild "--rebuild" $(basename ~path)))))
