/*
 * Decompiled with CFR 0.152.
 */
package cljd.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.BigInt;
import clojure.lang.Compiler;
import clojure.lang.IExceptionInfo;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentSet;
import clojure.lang.IPersistentVector;
import clojure.lang.IRecord;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Namespace;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.PersistentTreeMap;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.ReaderConditional;
import clojure.lang.Reflector;
import clojure.lang.Symbol;
import clojure.lang.TaggedLiteral;
import clojure.lang.Util;
import clojure.lang.Var;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LispReader {
    static final Var READER_RESOLVER = Var.intern((Namespace)RT.CLOJURE_NS, (Symbol)Symbol.intern((String)"*reader-resolver*"), null);
    static final Symbol _AMP_ = Symbol.intern((String)"&");
    static final Symbol FN = Symbol.intern((String)"fn*");
    static final Keyword TAG_KEY = Keyword.intern(null, (String)"tag");
    static Keyword LINE_KEY = Keyword.intern(null, (String)"line");
    static Keyword COLUMN_KEY = Keyword.intern(null, (String)"column");
    static Keyword END_LINE_KEY = Keyword.intern(null, (String)"end-line");
    static Keyword END_COLUMN_KEY = Keyword.intern(null, (String)"end-column");
    static final Symbol QUOTE = Symbol.intern((String)"quote");
    static final Symbol THE_VAR = Symbol.intern((String)"var");
    static Symbol UNQUOTE = Symbol.intern((String)"clojure.core", (String)"unquote");
    static Symbol UNQUOTE_SPLICING = Symbol.intern((String)"clojure.core", (String)"unquote-splicing");
    static Symbol CONCAT = Symbol.intern((String)"clojure.core", (String)"concat");
    static Symbol SEQ = Symbol.intern((String)"clojure.core", (String)"seq");
    static Symbol LIST = Symbol.intern((String)"clojure.core", (String)"list");
    static Symbol APPLY = Symbol.intern((String)"clojure.core", (String)"apply");
    static Symbol HASHMAP = Symbol.intern((String)"clojure.core", (String)"hash-map");
    static Symbol HASHSET = Symbol.intern((String)"clojure.core", (String)"hash-set");
    static Symbol VECTOR = Symbol.intern((String)"clojure.core", (String)"vector");
    static Symbol WITH_META = Symbol.intern((String)"clojure.core", (String)"with-meta");
    static Symbol META = Symbol.intern((String)"clojure.core", (String)"meta");
    static Symbol DEREF = Symbol.intern((String)"clojure.core", (String)"deref");
    static Symbol READ_COND = Symbol.intern((String)"clojure.core", (String)"read-cond");
    static Symbol READ_COND_SPLICING = Symbol.intern((String)"clojure.core", (String)"read-cond-splicing");
    static Keyword UNKNOWN = Keyword.intern(null, (String)"unknown");
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?(/|[\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
    static Var GENSYM_ENV = Var.create(null).setDynamic();
    static Var ARG_ENV = Var.create(null).setDynamic();
    static IFn ctorReader = new CtorReader();
    static Var READ_COND_ENV = Var.create(null).setDynamic();
    public static final Keyword OPT_EOF;
    public static final Keyword OPT_FEATURES;
    public static final Keyword OPT_READ_COND;
    public static final Keyword EOFTHROW;
    private static final Object PLATFORM_FEATURES;
    public static final Keyword COND_ALLOW;
    public static final Keyword COND_PRESERVE;
    private static final Object READ_EOF;
    private static final Object READ_FINISHED;

    static Namespace currentNS() {
        return (Namespace)RT.CURRENT_NS.deref();
    }

    static boolean isSpecial(Object object) {
        return Compiler.specials.containsKey(object);
    }

    static Symbol resolveSymbol(Symbol symbol) {
        if (symbol.getName().indexOf(46) > 0) {
            return symbol;
        }
        if (symbol.getNamespace() != null) {
            Namespace namespace = LispReader.namespaceFor(symbol);
            if (namespace == null || (namespace.name.getName() == null ? symbol.getNamespace() == null : namespace.name.getName().equals(symbol.getNamespace()))) {
                return symbol;
            }
            return Symbol.intern((String)namespace.name.getName(), (String)symbol.getName());
        }
        Object object = LispReader.currentNS().getMapping(symbol);
        if (object == null) {
            return Symbol.intern((String)LispReader.currentNS().name.getName(), (String)symbol.getName());
        }
        if (object instanceof Class) {
            return Symbol.intern(null, (String)((Class)object).getName());
        }
        if (object instanceof Var) {
            Var var = (Var)object;
            return Symbol.intern((String)var.ns.name.getName(), (String)var.sym.getName());
        }
        return null;
    }

    static Namespace namespaceFor(Symbol symbol) {
        return LispReader.namespaceFor(LispReader.currentNS(), symbol);
    }

    static Namespace namespaceFor(Namespace namespace, Symbol symbol) {
        Symbol symbol2 = Symbol.intern((String)symbol.getNamespace());
        Namespace namespace2 = namespace.lookupAlias(symbol2);
        if (namespace2 == null) {
            namespace2 = Namespace.find((Symbol)symbol2);
        }
        return namespace2;
    }

    static boolean isWhitespace(int n) {
        return Character.isWhitespace(n) || n == 44;
    }

    static void unread(PushbackReader pushbackReader, int n) {
        if (n != -1) {
            try {
                pushbackReader.unread(n);
            }
            catch (IOException iOException) {
                throw Util.sneakyThrow((Throwable)iOException);
            }
        }
    }

    public static int read1(Reader reader) {
        try {
            return reader.read();
        }
        catch (IOException iOException) {
            throw Util.sneakyThrow((Throwable)iOException);
        }
    }

    public static Object read(PushbackReader pushbackReader, Object object) {
        Object object2;
        boolean bl = true;
        Object object3 = null;
        if (object != null && object instanceof IPersistentMap && !EOFTHROW.equals(object2 = ((IPersistentMap)object).valAt((Object)OPT_EOF, (Object)EOFTHROW))) {
            bl = false;
            object3 = object2;
        }
        return LispReader.read(pushbackReader, bl, object3, false, object);
    }

    public static Object read(PushbackReader pushbackReader, boolean bl, Object object, boolean bl2) {
        return LispReader.read(pushbackReader, bl, object, bl2, PersistentHashMap.EMPTY);
    }

    public static Object read(PushbackReader pushbackReader, boolean bl, Object object, boolean bl2, Object object2) {
        return LispReader.read(pushbackReader, bl, object, null, null, bl2, object2, null, (Resolver)READER_RESOLVER.deref());
    }

    private static Object read(PushbackReader pushbackReader, boolean bl, Object object, boolean bl2, Object object2, Object object3) {
        return LispReader.read(pushbackReader, bl, object, null, null, bl2, object2, LispReader.ensurePending(object3), (Resolver)READER_RESOLVER.deref());
    }

    private static Object ensurePending(Object object) {
        if (object == null) {
            return new LinkedList();
        }
        return object;
    }

    private static Object installPlatformFeature(Object object) {
        if (object == null) {
            return RT.mapUniqueKeys((Object[])new Object[]{OPT_FEATURES, PLATFORM_FEATURES});
        }
        IPersistentMap iPersistentMap = (IPersistentMap)object;
        Object object2 = iPersistentMap.valAt((Object)OPT_FEATURES);
        if (object2 == null) {
            return iPersistentMap.assoc((Object)OPT_FEATURES, PLATFORM_FEATURES);
        }
        return iPersistentMap.assoc((Object)OPT_FEATURES, object2);
    }

    private static Object read(PushbackReader pushbackReader, boolean bl, Object object, Character c, Object object2, boolean bl2, Object object3, Object object4, Resolver resolver) {
        if (RT.READEVAL.deref() == UNKNOWN) {
            throw Util.runtimeException((String)"Reading disallowed - *read-eval* bound to :unknown");
        }
        object3 = LispReader.installPlatformFeature(object3);
        try {
            int n;
            block13: {
                Object object5;
                Object object6;
                do {
                    if (object4 instanceof List && !((List)object4).isEmpty()) {
                        return ((List)object4).remove(0);
                    }
                    n = LispReader.read1(pushbackReader);
                    while (LispReader.isWhitespace(n)) {
                        n = LispReader.read1(pushbackReader);
                    }
                    if (n == -1) {
                        if (bl) {
                            throw Util.runtimeException((String)"EOF while reading");
                        }
                        return object;
                    }
                    if (c != null && c.charValue() == n) {
                        return object2;
                    }
                    if (Character.isDigit(n)) {
                        object5 = LispReader.readNumber(pushbackReader, (char)n);
                        return object5;
                    }
                    object5 = LispReader.getMacro(n);
                    if (object5 == null) break block13;
                } while ((object6 = object5.invoke((Object)pushbackReader, (Object)Character.valueOf((char)n), object3, object4)) == pushbackReader);
                return object6;
            }
            if (n == 43 || n == 45) {
                int n2 = LispReader.read1(pushbackReader);
                if (Character.isDigit(n2)) {
                    LispReader.unread(pushbackReader, n2);
                    Object object7 = LispReader.readNumber(pushbackReader, (char)n);
                    return object7;
                }
                LispReader.unread(pushbackReader, n2);
            }
            String string = LispReader.readToken(pushbackReader, (char)n);
            return LispReader.interpretToken(string, resolver);
        }
        catch (Exception exception) {
            if (bl2 || !(pushbackReader instanceof LineNumberingPushbackReader)) {
                throw Util.sneakyThrow((Throwable)exception);
            }
            LineNumberingPushbackReader lineNumberingPushbackReader = (LineNumberingPushbackReader)pushbackReader;
            throw new ReaderException(lineNumberingPushbackReader.getLineNumber(), lineNumberingPushbackReader.getColumnNumber(), exception);
        }
    }

    private static String readToken(PushbackReader pushbackReader, char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        while (true) {
            int n;
            if ((n = LispReader.read1(pushbackReader)) == -1 || LispReader.isWhitespace(n) || LispReader.isTerminatingMacro(n)) {
                LispReader.unread(pushbackReader, n);
                return stringBuilder.toString();
            }
            stringBuilder.append((char)n);
        }
    }

    private static Object readNumber(PushbackReader pushbackReader, char c) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(c);
        while (true) {
            if ((n = LispReader.read1(pushbackReader)) == -1 || LispReader.isWhitespace(n) || LispReader.isMacro(n)) break;
            stringBuilder.append((char)n);
        }
        LispReader.unread(pushbackReader, n);
        String string = stringBuilder.toString();
        Object object = LispReader.matchNumber(string);
        if (object == null) {
            throw new NumberFormatException("Invalid number: " + string);
        }
        return object;
    }

    private static int readUnicodeChar(String string, int n, int n2, int n3) {
        if (string.length() != n + n2) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + string);
        }
        int n4 = 0;
        for (int i = n; i < n + n2; ++i) {
            int n5 = Character.digit(string.charAt(i), n3);
            if (n5 == -1) {
                throw new IllegalArgumentException("Invalid digit: " + string.charAt(i));
            }
            n4 = n4 * n3 + n5;
        }
        return (char)n4;
    }

    private static int readUnicodeChar(PushbackReader pushbackReader, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = Character.digit(n, n2);
        if (n5 == -1) {
            throw new IllegalArgumentException("Invalid digit: " + (char)n);
        }
        for (n4 = 1; n4 < n3; ++n4) {
            int n6 = LispReader.read1(pushbackReader);
            if (n6 == -1 || LispReader.isWhitespace(n6) || LispReader.isMacro(n6)) {
                LispReader.unread(pushbackReader, n6);
                break;
            }
            int n7 = Character.digit(n6, n2);
            if (n7 == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)n6);
            }
            n5 = n5 * n2 + n7;
        }
        if (n4 != n3 && bl) {
            throw new IllegalArgumentException("Invalid character length: " + n4 + ", should be: " + n3);
        }
        return n5;
    }

    private static Object interpretToken(String string, Resolver resolver) {
        if (string.equals("nil")) {
            return null;
        }
        if (string.equals("true")) {
            return RT.T;
        }
        if (string.equals("false")) {
            return RT.F;
        }
        Object object = null;
        object = LispReader.matchSymbol(string, resolver);
        if (object != null) {
            return object;
        }
        throw Util.runtimeException((String)("Invalid token: " + string));
    }

    private static Object matchSymbol(String string, Resolver resolver) {
        Matcher matcher = symbolPat.matcher(string);
        if (matcher.matches()) {
            int n = matcher.groupCount();
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2 != null && string2.endsWith(":/") || string3.endsWith(":") || string.indexOf("::", 1) != -1) {
                return null;
            }
            if (string.startsWith("::")) {
                Symbol symbol = Symbol.intern((String)string.substring(2));
                if (resolver != null) {
                    Symbol symbol2 = symbol.getNamespace() != null ? resolver.resolveAlias(Symbol.intern((String)symbol.getNamespace())) : resolver.currentNS();
                    if (symbol2 != null) {
                        return Keyword.intern((String)symbol2.getName(), (String)symbol.getName());
                    }
                    return null;
                }
                Namespace namespace = symbol.getNamespace() != null ? LispReader.currentNS().lookupAlias(Symbol.intern((String)symbol.getNamespace())) : LispReader.currentNS();
                if (namespace != null) {
                    return Keyword.intern((String)namespace.name.getName(), (String)symbol.getName());
                }
                return null;
            }
            boolean bl = string.charAt(0) == ':';
            Symbol symbol = Symbol.intern((String)string.substring(bl ? 1 : 0));
            if (bl) {
                return Keyword.intern((Symbol)symbol);
            }
            return symbol;
        }
        return null;
    }

    private static Object matchNumber(String string) {
        Matcher matcher = intPat.matcher(string);
        if (matcher.matches()) {
            if (matcher.group(2) != null) {
                if (matcher.group(8) != null) {
                    return BigInt.ZERO;
                }
                return Numbers.num((long)0L);
            }
            boolean bl = matcher.group(1).equals("-");
            int n = 10;
            String string2 = matcher.group(3);
            if (string2 != null) {
                n = 10;
            } else {
                string2 = matcher.group(4);
                if (string2 != null) {
                    n = 16;
                } else {
                    string2 = matcher.group(5);
                    if (string2 != null) {
                        n = 8;
                    } else {
                        string2 = matcher.group(7);
                        if (string2 != null) {
                            n = Integer.parseInt(matcher.group(6));
                        }
                    }
                }
            }
            if (string2 == null) {
                return null;
            }
            BigInteger bigInteger = new BigInteger(string2, n);
            if (bl) {
                bigInteger = bigInteger.negate();
            }
            if (matcher.group(8) != null) {
                return BigInt.fromBigInteger((BigInteger)bigInteger);
            }
            return bigInteger.bitLength() < 64 ? Numbers.num((long)bigInteger.longValue()) : BigInt.fromBigInteger((BigInteger)bigInteger);
        }
        matcher = floatPat.matcher(string);
        if (matcher.matches()) {
            if (matcher.group(4) != null) {
                return new BigDecimal(matcher.group(1));
            }
            return Double.parseDouble(string);
        }
        matcher = ratioPat.matcher(string);
        if (matcher.matches()) {
            String string3 = matcher.group(1);
            if (string3.startsWith("+")) {
                string3 = string3.substring(1);
            }
            return Numbers.divide((Object)Numbers.reduceBigInt((BigInt)BigInt.fromBigInteger((BigInteger)new BigInteger(string3))), (Object)Numbers.reduceBigInt((BigInt)BigInt.fromBigInteger((BigInteger)new BigInteger(matcher.group(2)))));
        }
        return null;
    }

    private static IFn getMacro(int n) {
        if (n < macros.length) {
            return macros[n];
        }
        return null;
    }

    private static boolean isMacro(int n) {
        return n < macros.length && macros[n] != null;
    }

    private static boolean isTerminatingMacro(int n) {
        return n != 35 && n != 39 && n != 37 && LispReader.isMacro(n);
    }

    static Symbol garg(int n) {
        return Symbol.intern(null, (String)((String)(n == -1 ? "rest" : "p" + n) + "__" + RT.nextID() + "#"));
    }

    static Symbol registerArg(int n) {
        PersistentTreeMap persistentTreeMap = (PersistentTreeMap)ARG_ENV.deref();
        if (persistentTreeMap == null) {
            throw new IllegalStateException("arg literal not in #()");
        }
        Symbol symbol = (Symbol)persistentTreeMap.valAt((Object)n);
        if (symbol == null) {
            symbol = LispReader.garg(n);
            ARG_ENV.set((Object)persistentTreeMap.assoc((Object)n, (Object)symbol));
        }
        return symbol;
    }

    static boolean isUnquoteSplicing(Object object) {
        return object instanceof ISeq && Util.equals((Object)RT.first((Object)object), (Object)UNQUOTE_SPLICING);
    }

    static boolean isUnquote(Object object) {
        return object instanceof ISeq && Util.equals((Object)RT.first((Object)object), (Object)UNQUOTE);
    }

    public static List readDelimitedList(char c, PushbackReader pushbackReader, boolean bl, Object object, Object object2) {
        int n = pushbackReader instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)pushbackReader).getLineNumber() : -1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Resolver resolver = (Resolver)READER_RESOLVER.deref();
        while (true) {
            Object object3;
            if ((object3 = LispReader.read(pushbackReader, false, READ_EOF, Character.valueOf(c), READ_FINISHED, bl, object, object2, resolver)) == READ_EOF) {
                if (n < 0) {
                    throw Util.runtimeException((String)"EOF while reading");
                }
                throw Util.runtimeException((String)("EOF while reading, starting at line " + n));
            }
            if (object3 == READ_FINISHED) {
                return arrayList;
            }
            arrayList.add(object3);
        }
    }

    static boolean isPreserveReadCond(Object object) {
        if (RT.booleanCast((Object)READ_COND_ENV.deref()) && object instanceof IPersistentMap) {
            Object object2 = ((IPersistentMap)object).valAt((Object)OPT_READ_COND);
            return COND_PRESERVE.equals(object2);
        }
        return false;
    }

    static {
        LispReader.macros[34] = new StringReader();
        LispReader.macros[59] = new CommentReader();
        LispReader.macros[39] = new WrappingReader(QUOTE);
        LispReader.macros[64] = new WrappingReader(DEREF);
        LispReader.macros[94] = new MetaReader();
        LispReader.macros[96] = new SyntaxQuoteReader();
        LispReader.macros[126] = new UnquoteReader();
        LispReader.macros[40] = new ListReader();
        LispReader.macros[41] = new UnmatchedDelimiterReader();
        LispReader.macros[91] = new VectorReader();
        LispReader.macros[93] = new UnmatchedDelimiterReader();
        LispReader.macros[123] = new MapReader();
        LispReader.macros[125] = new UnmatchedDelimiterReader();
        LispReader.macros[92] = new CharacterReader();
        LispReader.macros[37] = new ArgReader();
        LispReader.macros[35] = new DispatchReader();
        LispReader.dispatchMacros[94] = new MetaReader();
        LispReader.dispatchMacros[35] = new SymbolicValueReader();
        LispReader.dispatchMacros[39] = new VarReader();
        LispReader.dispatchMacros[34] = new RegexReader();
        LispReader.dispatchMacros[40] = new FnReader();
        LispReader.dispatchMacros[123] = new SetReader();
        LispReader.dispatchMacros[61] = new EvalReader();
        LispReader.dispatchMacros[33] = new CommentReader();
        LispReader.dispatchMacros[60] = new UnreadableReader();
        LispReader.dispatchMacros[95] = new DiscardReader();
        LispReader.dispatchMacros[63] = new ConditionalReader();
        LispReader.dispatchMacros[58] = new NamespaceMapReader();
        OPT_EOF = Keyword.intern(null, (String)"eof");
        OPT_FEATURES = Keyword.intern(null, (String)"features");
        OPT_READ_COND = Keyword.intern(null, (String)"read-cond");
        EOFTHROW = Keyword.intern(null, (String)"eofthrow");
        PLATFORM_FEATURES = PersistentHashSet.EMPTY;
        COND_ALLOW = Keyword.intern(null, (String)"allow");
        COND_PRESERVE = Keyword.intern(null, (String)"preserve");
        READ_EOF = new Object();
        READ_FINISHED = new Object();
    }

    public static interface Resolver {
        public Symbol currentNS();

        public Symbol resolveClass(Symbol var1);

        public Symbol resolveAlias(Symbol var1);

        public Symbol resolveVar(Symbol var1);
    }

    public static class ReaderException
    extends RuntimeException
    implements IExceptionInfo {
        public final int line;
        public final int column;
        public final Object data;
        public static final String ERR_NS = "clojure.error";
        public static final Keyword ERR_LINE = Keyword.intern((String)"clojure.error", (String)"line");
        public static final Keyword ERR_COLUMN = Keyword.intern((String)"clojure.error", (String)"column");

        public ReaderException(int n, int n2, Throwable throwable) {
            super(throwable);
            this.line = n;
            this.column = n2;
            this.data = RT.map((Object[])new Object[]{ERR_LINE, n, ERR_COLUMN, n2});
        }

        public IPersistentMap getData() {
            return (IPersistentMap)this.data;
        }
    }

    public static class CtorReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, false, object3, object4 = LispReader.ensurePending(object4));
            if (!(object5 instanceof Symbol)) {
                throw new RuntimeException("Reader tag must be a symbol");
            }
            Symbol symbol = (Symbol)object5;
            Object object6 = LispReader.read(pushbackReader, true, null, true, object3, object4);
            if (LispReader.isPreserveReadCond(object3) || RT.suppressRead()) {
                return TaggedLiteral.create((Symbol)symbol, (Object)object6);
            }
            return symbol.getName().contains(".") ? this.readRecord(object6, symbol, object3, object4) : this.readTagged(object6, symbol, object3, object4);
        }

        private Object readTagged(Object object, Symbol symbol, Object object2, Object object3) {
            ILookup iLookup = (ILookup)RT.DATA_READERS.deref();
            IFn iFn = (IFn)RT.get((Object)iLookup, (Object)symbol);
            if (iFn == null && (iFn = (IFn)RT.get((Object)(iLookup = (ILookup)RT.DEFAULT_DATA_READERS.deref()), (Object)symbol)) == null) {
                IFn iFn2 = (IFn)RT.DEFAULT_DATA_READER_FN.deref();
                if (iFn2 != null) {
                    return iFn2.invoke((Object)symbol, object);
                }
                throw new RuntimeException("No reader function for tag " + symbol.toString());
            }
            return iFn.invoke(object);
        }

        private Object readRecord(Object object, Symbol symbol, Object object2, Object object3) {
            boolean bl = RT.booleanCast((Object)RT.READEVAL.deref());
            if (!bl) {
                throw Util.runtimeException((String)"Record construction syntax can only be used when *read-eval* == true");
            }
            Class clazz = RT.classForNameNonLoading((String)symbol.toString());
            boolean bl2 = true;
            if (object instanceof IPersistentMap) {
                bl2 = false;
            } else if (object instanceof IPersistentVector) {
                bl2 = true;
            } else {
                throw Util.runtimeException((String)("Unreadable constructor form starting with \"#" + String.valueOf(symbol) + "\""));
            }
            Object object4 = null;
            Constructor<?>[] constructorArray = clazz.getConstructors();
            if (bl2) {
                IPersistentVector iPersistentVector = (IPersistentVector)object;
                boolean bl3 = false;
                for (Constructor<?> constructor : constructorArray) {
                    if (constructor.getParameterTypes().length != iPersistentVector.count()) continue;
                    bl3 = true;
                }
                if (!bl3) {
                    throw Util.runtimeException((String)("Unexpected number of constructor arguments to " + clazz.toString() + ": got " + iPersistentVector.count()));
                }
                object4 = Reflector.invokeConstructor((Class)clazz, (Object[])RT.toArray((Object)iPersistentVector));
            } else {
                IPersistentMap iPersistentMap = (IPersistentMap)object;
                for (ISeq iSeq = RT.keys((Object)iPersistentMap); iSeq != null; iSeq = iSeq.next()) {
                    if (iSeq.first() instanceof Keyword) continue;
                    throw Util.runtimeException((String)("Unreadable defrecord form: key must be of type clojure.lang.Keyword, got " + iSeq.first().toString()));
                }
                object4 = Reflector.invokeStaticMethod((Class)clazz, (String)"create", (Object[])new Object[]{iPersistentMap});
            }
            return object4;
        }
    }

    public static class StringReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            StringBuilder stringBuilder = new StringBuilder();
            Reader reader = (Reader)object;
            int n = LispReader.read1(reader);
            while (n != 34) {
                if (n == -1) {
                    throw Util.runtimeException((String)"EOF while reading string");
                }
                if (n == 92) {
                    n = LispReader.read1(reader);
                    if (n == -1) {
                        throw Util.runtimeException((String)"EOF while reading string");
                    }
                    switch (n) {
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 117: {
                            n = LispReader.read1(reader);
                            if (Character.digit(n, 16) == -1) {
                                throw Util.runtimeException((String)("Invalid unicode escape: \\u" + (char)n));
                            }
                            n = LispReader.readUnicodeChar((PushbackReader)reader, n, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(n)) {
                                if ((n = LispReader.readUnicodeChar((PushbackReader)reader, n, 8, 3, false)) <= 255) break;
                                throw Util.runtimeException((String)"Octal escape sequence must be in range [0, 377].");
                            }
                            throw Util.runtimeException((String)("Unsupported escape character: \\" + (char)n));
                        }
                    }
                }
                stringBuilder.append((char)n);
                n = LispReader.read1(reader);
            }
            return stringBuilder.toString();
        }
    }

    public static class CommentReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            int n;
            Reader reader = (Reader)object;
            while ((n = LispReader.read1(reader)) != -1 && n != 10 && n != 13) {
            }
            return reader;
        }
    }

    public static class WrappingReader
    extends AFn {
        final Symbol sym;

        public WrappingReader(Symbol symbol) {
            this.sym = symbol;
        }

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            return RT.list((Object)this.sym, (Object)object5);
        }
    }

    public static class MetaReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            Object object5;
            PushbackReader pushbackReader = (PushbackReader)object;
            int n = -1;
            int n2 = -1;
            if (pushbackReader instanceof LineNumberingPushbackReader) {
                n = ((LineNumberingPushbackReader)pushbackReader).getLineNumber();
                n2 = ((LineNumberingPushbackReader)pushbackReader).getColumnNumber() - 1;
            }
            if ((object5 = LispReader.read(pushbackReader, true, null, true, object3, object4 = LispReader.ensurePending(object4))) instanceof Symbol || object5 instanceof String) {
                object5 = RT.map((Object[])new Object[]{TAG_KEY, object5});
            } else if (object5 instanceof Keyword) {
                object5 = RT.map((Object[])new Object[]{object5, RT.T});
            } else if (!(object5 instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object object6 = LispReader.read(pushbackReader, true, null, true, object3, object4);
            if (object6 instanceof IMeta) {
                if (n != -1 && object6 instanceof ISeq) {
                    object5 = RT.assoc((Object)object5, (Object)LINE_KEY, (Object)RT.get((Object)object5, (Object)LINE_KEY, (Object)n));
                    object5 = RT.assoc((Object)object5, (Object)COLUMN_KEY, (Object)RT.get((Object)object5, (Object)COLUMN_KEY, (Object)n2));
                    object5 = RT.assoc((Object)object5, (Object)END_LINE_KEY, (Object)RT.get((Object)object5, (Object)END_LINE_KEY, (Object)((LineNumberingPushbackReader)pushbackReader).getLineNumber()));
                    object5 = RT.assoc((Object)object5, (Object)END_COLUMN_KEY, (Object)RT.get((Object)object5, (Object)END_COLUMN_KEY, (Object)(((LineNumberingPushbackReader)pushbackReader).getColumnNumber() - 1)));
                }
                if (object6 instanceof IReference) {
                    ((IReference)object6).resetMeta((IPersistentMap)object5);
                    return object6;
                }
                IPersistentMap iPersistentMap = RT.meta((Object)object6);
                for (ISeq iSeq = RT.seq((Object)object5); iSeq != null; iSeq = iSeq.next()) {
                    IMapEntry iMapEntry = (IMapEntry)iSeq.first();
                    iPersistentMap = RT.assoc((Object)iPersistentMap, (Object)iMapEntry.getKey(), (Object)iMapEntry.getValue());
                }
                return ((IObj)object6).withMeta(iPersistentMap);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    public static class SyntaxQuoteReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            try {
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{GENSYM_ENV, PersistentHashMap.EMPTY}));
                Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
                Object object6 = SyntaxQuoteReader.syntaxQuote(object5);
                return object6;
            }
            finally {
                Var.popThreadBindings();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static Object syntaxQuote(Object object) {
            void var1_12;
            Resolver resolver;
            if (LispReader.isSpecial(object)) {
                ISeq iSeq = RT.list((Object)QUOTE, (Object)object);
            } else if (object instanceof Symbol) {
                resolver = (Resolver)READER_RESOLVER.deref();
                Symbol symbol = (Symbol)object;
                if (symbol.getNamespace() == null && symbol.getName().endsWith("#")) {
                    IPersistentMap iPersistentMap = (IPersistentMap)GENSYM_ENV.deref();
                    if (iPersistentMap == null) {
                        throw new IllegalStateException("Gensym literal not in syntax-quote");
                    }
                    Symbol symbol2 = (Symbol)iPersistentMap.valAt((Object)symbol);
                    if (symbol2 == null) {
                        symbol2 = Symbol.intern(null, (String)(symbol.getName().substring(0, symbol.getName().length() - 1) + "__" + RT.nextID() + "__auto__"));
                        GENSYM_ENV.set((Object)iPersistentMap.assoc((Object)symbol, (Object)symbol2));
                    }
                    symbol = symbol2;
                } else if (symbol.getNamespace() == null && symbol.getName().endsWith(".")) {
                    Symbol symbol3 = Symbol.intern(null, (String)symbol.getName().substring(0, symbol.getName().length() - 1));
                    if (resolver != null) {
                        Symbol symbol4 = resolver.resolveClass(symbol3);
                        if (symbol4 != null) {
                            symbol3 = symbol4;
                        }
                    } else {
                        symbol3 = LispReader.resolveSymbol(symbol3);
                    }
                    symbol = Symbol.intern(null, (String)symbol3.getName().concat("."));
                } else if (symbol.getNamespace() != null || !symbol.getName().startsWith(".")) {
                    if (resolver != null) {
                        Symbol symbol5;
                        Symbol symbol6 = null;
                        if (symbol.getNamespace() != null && (symbol6 = resolver.resolveClass(symbol5 = Symbol.intern(null, (String)symbol.getNamespace()))) == null) {
                            symbol6 = resolver.resolveAlias(symbol5);
                        }
                        if (symbol6 != null) {
                            symbol = Symbol.intern((String)symbol6.getName(), (String)symbol.getName());
                        } else if (symbol.getNamespace() == null) {
                            symbol5 = resolver.resolveClass(symbol);
                            if (symbol5 == null) {
                                symbol5 = resolver.resolveVar(symbol);
                            }
                            symbol = symbol5 != null ? symbol5 : Symbol.intern((String)resolver.currentNS().getName(), (String)symbol.getName());
                        }
                    } else {
                        Object object2 = null;
                        if (symbol.getNamespace() != null) {
                            object2 = LispReader.currentNS().getMapping(Symbol.intern(null, (String)symbol.getNamespace()));
                        }
                        symbol = object2 instanceof Class ? Symbol.intern((String)((Class)object2).getName(), (String)symbol.getName()) : LispReader.resolveSymbol(symbol);
                    }
                }
                ISeq iSeq = RT.list((Object)QUOTE, (Object)symbol);
            } else {
                if (LispReader.isUnquote(object)) {
                    return RT.second((Object)object);
                }
                if (LispReader.isUnquoteSplicing(object)) {
                    throw new IllegalStateException("splice not in list");
                }
                if (object instanceof IPersistentCollection) {
                    if (object instanceof IRecord) {
                        Object object3 = object;
                    } else if (object instanceof IPersistentMap) {
                        resolver = SyntaxQuoteReader.flattenMap(object);
                        ISeq iSeq = RT.list((Object)APPLY, (Object)HASHMAP, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(resolver.seq()))));
                    } else if (object instanceof IPersistentVector) {
                        ISeq iSeq = RT.list((Object)APPLY, (Object)VECTOR, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(((IPersistentVector)object).seq()))));
                    } else if (object instanceof IPersistentSet) {
                        ISeq iSeq = RT.list((Object)APPLY, (Object)HASHSET, (Object)RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList(((IPersistentSet)object).seq()))));
                    } else {
                        if (!(object instanceof ISeq) && !(object instanceof IPersistentList)) throw new UnsupportedOperationException("Unknown Collection type");
                        resolver = RT.seq((Object)object);
                        if (resolver == null) {
                            ISeq iSeq = RT.cons((Object)LIST, null);
                        } else {
                            ISeq iSeq = RT.list((Object)SEQ, (Object)RT.cons((Object)CONCAT, (Object)SyntaxQuoteReader.sqExpandList((ISeq)resolver)));
                        }
                    }
                } else if (object instanceof Keyword || object instanceof Number || object instanceof Character || object instanceof String) {
                    Object object4 = object;
                } else {
                    ISeq iSeq = RT.list((Object)QUOTE, (Object)object);
                }
            }
            if (!(object instanceof IObj) || RT.meta((Object)object) == null || (resolver = ((IObj)object).meta().without((Object)LINE_KEY).without((Object)COLUMN_KEY).without((Object)END_LINE_KEY).without((Object)END_COLUMN_KEY)).count() <= 0) return var1_12;
            return RT.list((Object)WITH_META, (Object)var1_12, (Object)SyntaxQuoteReader.syntaxQuote(((IObj)object).meta()));
        }

        private static ISeq sqExpandList(ISeq iSeq) {
            PersistentVector persistentVector = PersistentVector.EMPTY;
            while (iSeq != null) {
                Object object = iSeq.first();
                persistentVector = LispReader.isUnquote(object) ? persistentVector.cons((Object)RT.list((Object)LIST, (Object)RT.second((Object)object))) : (LispReader.isUnquoteSplicing(object) ? persistentVector.cons(RT.second((Object)object)) : persistentVector.cons((Object)RT.list((Object)LIST, (Object)SyntaxQuoteReader.syntaxQuote(object))));
                iSeq = iSeq.next();
            }
            return persistentVector.seq();
        }

        private static IPersistentVector flattenMap(Object object) {
            PersistentVector persistentVector = PersistentVector.EMPTY;
            for (ISeq iSeq = RT.seq((Object)object); iSeq != null; iSeq = iSeq.next()) {
                IMapEntry iMapEntry = (IMapEntry)iSeq.first();
                persistentVector = persistentVector.cons(iMapEntry.key());
                persistentVector = persistentVector.cons(iMapEntry.val());
            }
            return persistentVector;
        }
    }

    static class UnquoteReader
    extends AFn {
        UnquoteReader() {
        }

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            int n = LispReader.read1(pushbackReader);
            if (n == -1) {
                throw Util.runtimeException((String)"EOF while reading character");
            }
            object4 = LispReader.ensurePending(object4);
            if (n == 64) {
                Object object5 = LispReader.read(pushbackReader, true, null, true, object3, object4);
                return RT.list((Object)UNQUOTE_SPLICING, (Object)object5);
            }
            LispReader.unread(pushbackReader, n);
            Object object6 = LispReader.read(pushbackReader, true, null, true, object3, object4);
            return RT.list((Object)UNQUOTE, (Object)object6);
        }
    }

    public static class ListReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            List list;
            PushbackReader pushbackReader = (PushbackReader)object;
            int n = -1;
            int n2 = -1;
            if (pushbackReader instanceof LineNumberingPushbackReader) {
                n = ((LineNumberingPushbackReader)pushbackReader).getLineNumber();
                n2 = ((LineNumberingPushbackReader)pushbackReader).getColumnNumber() - 1;
            }
            if ((list = LispReader.readDelimitedList(')', pushbackReader, true, object3, LispReader.ensurePending(object4))).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj iObj = (IObj)PersistentList.create((List)list);
            if (n != -1) {
                IPersistentMap iPersistentMap = RT.meta((Object)iObj);
                iPersistentMap = RT.assoc((Object)iPersistentMap, (Object)LINE_KEY, (Object)RT.get((Object)iPersistentMap, (Object)LINE_KEY, (Object)n));
                iPersistentMap = RT.assoc((Object)iPersistentMap, (Object)COLUMN_KEY, (Object)RT.get((Object)iPersistentMap, (Object)COLUMN_KEY, (Object)n2));
                iPersistentMap = RT.assoc((Object)iPersistentMap, (Object)END_LINE_KEY, (Object)RT.get((Object)iPersistentMap, (Object)END_LINE_KEY, (Object)((LineNumberingPushbackReader)pushbackReader).getLineNumber()));
                iPersistentMap = RT.assoc((Object)iPersistentMap, (Object)END_COLUMN_KEY, (Object)RT.get((Object)iPersistentMap, (Object)END_COLUMN_KEY, (Object)(((LineNumberingPushbackReader)pushbackReader).getColumnNumber() - 1)));
                return iObj.withMeta(iPersistentMap);
            }
            return iObj;
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            throw Util.runtimeException((String)("Unmatched delimiter: " + String.valueOf(object2)));
        }
    }

    public static class VectorReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            return LazilyPersistentVector.create((Object)LispReader.readDelimitedList(']', pushbackReader, true, object3, LispReader.ensurePending(object4)));
        }
    }

    public static class MapReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            Object[] objectArray = LispReader.readDelimitedList('}', pushbackReader, true, object3, LispReader.ensurePending(object4)).toArray();
            if ((objectArray.length & 1) == 1) {
                throw Util.runtimeException((String)"Map literal must contain an even number of forms");
            }
            return RT.map((Object[])objectArray);
        }
    }

    public static class CharacterReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            int n = LispReader.read1(pushbackReader);
            if (n == -1) {
                throw Util.runtimeException((String)"EOF while reading character");
            }
            String string = LispReader.readToken(pushbackReader, (char)n);
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            if (string.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (string.equals("space")) {
                return Character.valueOf(' ');
            }
            if (string.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (string.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (string.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (string.equals("return")) {
                return Character.valueOf('\r');
            }
            if (string.startsWith("u")) {
                char c = (char)LispReader.readUnicodeChar(string, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw Util.runtimeException((String)("Invalid character constant: \\u" + Integer.toString(c, 16)));
                }
                return Character.valueOf(c);
            }
            if (string.startsWith("o")) {
                int n2 = string.length() - 1;
                if (n2 > 3) {
                    throw Util.runtimeException((String)("Invalid octal escape sequence length: " + n2));
                }
                int n3 = LispReader.readUnicodeChar(string, 1, n2, 8);
                if (n3 > 255) {
                    throw Util.runtimeException((String)"Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)n3);
            }
            throw Util.runtimeException((String)("Unsupported character: \\" + string));
        }
    }

    static class ArgReader
    extends AFn {
        ArgReader() {
        }

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            if (ARG_ENV.deref() == null) {
                return LispReader.interpretToken(LispReader.readToken(pushbackReader, '%'), null);
            }
            int n = LispReader.read1(pushbackReader);
            LispReader.unread(pushbackReader, n);
            if (n == -1 || LispReader.isWhitespace(n) || LispReader.isTerminatingMacro(n)) {
                return LispReader.registerArg(1);
            }
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            if (object5.equals(_AMP_)) {
                return LispReader.registerArg(-1);
            }
            if (!(object5 instanceof Number)) {
                throw new IllegalStateException("arg literal must be %, %& or %integer");
            }
            return LispReader.registerArg(((Number)object5).intValue());
        }
    }

    public static class DispatchReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            int n = LispReader.read1((Reader)object);
            if (n == -1) {
                throw Util.runtimeException((String)"EOF while reading character");
            }
            IFn iFn = dispatchMacros[n];
            if (iFn == null) {
                LispReader.unread((PushbackReader)object, n);
                object4 = LispReader.ensurePending(object4);
                Object object5 = ctorReader.invoke(object, (Object)n, object3, object4);
                if (object5 != null) {
                    return object5;
                }
                throw Util.runtimeException((String)String.format("No dispatch macro for: %c", Character.valueOf((char)n)));
            }
            return iFn.invoke(object, (Object)n, object3, object4);
        }
    }

    public static class SymbolicValueReader
    extends AFn {
        static IPersistentMap specials = PersistentHashMap.create((Object[])new Object[]{Symbol.intern((String)"Inf"), Double.POSITIVE_INFINITY, Symbol.intern((String)"-Inf"), Double.NEGATIVE_INFINITY, Symbol.intern((String)"NaN"), Double.NaN});

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            if (!(object5 instanceof Symbol)) {
                throw Util.runtimeException((String)("Invalid token: ##" + String.valueOf(object5)));
            }
            if (!specials.containsKey(object5)) {
                throw Util.runtimeException((String)("Unknown symbolic value: ##" + String.valueOf(object5)));
            }
            return specials.valAt(object5);
        }
    }

    public static class VarReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            return RT.list((Object)THE_VAR, (Object)object5);
        }
    }

    public static class RegexReader
    extends AFn {
        static StringReader stringrdr = new StringReader();

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            StringBuilder stringBuilder = new StringBuilder();
            Reader reader = (Reader)object;
            int n = LispReader.read1(reader);
            while (n != 34) {
                if (n == -1) {
                    throw Util.runtimeException((String)"EOF while reading regex");
                }
                stringBuilder.append((char)n);
                if (n == 92) {
                    n = LispReader.read1(reader);
                    if (n == -1) {
                        throw Util.runtimeException((String)"EOF while reading regex");
                    }
                    stringBuilder.append((char)n);
                }
                n = LispReader.read1(reader);
            }
            return Pattern.compile(stringBuilder.toString());
        }
    }

    public static class FnReader
    extends AFn {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            if (ARG_ENV.deref() != null) {
                throw new IllegalStateException("Nested #()s are not allowed");
            }
            try {
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{ARG_ENV, PersistentTreeMap.EMPTY}));
                LispReader.unread(pushbackReader, 40);
                Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
                PersistentVector persistentVector = PersistentVector.EMPTY;
                PersistentTreeMap persistentTreeMap = (PersistentTreeMap)ARG_ENV.deref();
                ISeq iSeq = persistentTreeMap.rseq();
                if (iSeq != null) {
                    Object object6;
                    int n = (Integer)((Map.Entry)iSeq.first()).getKey();
                    if (n > 0) {
                        for (int i = 1; i <= n; ++i) {
                            Object object7 = persistentTreeMap.valAt((Object)i);
                            if (object7 == null) {
                                object7 = LispReader.garg(i);
                            }
                            persistentVector = persistentVector.cons(object7);
                        }
                    }
                    if ((object6 = persistentTreeMap.valAt((Object)-1)) != null) {
                        persistentVector = persistentVector.cons((Object)_AMP_);
                        persistentVector = persistentVector.cons(object6);
                    }
                }
                ISeq iSeq2 = RT.list((Object)FN, (Object)persistentVector, (Object)object5);
                return iSeq2;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class SetReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            return PersistentHashSet.createWithCheck((List)LispReader.readDelimitedList('}', pushbackReader, true, object3, LispReader.ensurePending(object4)));
        }
    }

    public static class EvalReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            if (!RT.booleanCast((Object)RT.READEVAL.deref())) {
                throw Util.runtimeException((String)"EvalReader not allowed when *read-eval* is false.");
            }
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            if (object5 instanceof Symbol) {
                return RT.classForName((String)object5.toString());
            }
            if (object5 instanceof IPersistentList) {
                Symbol symbol = (Symbol)RT.first((Object)object5);
                if (symbol.equals((Object)THE_VAR)) {
                    Symbol symbol2 = (Symbol)RT.second((Object)object5);
                    return RT.var((String)symbol2.getNamespace(), (String)symbol2.getName());
                }
                if (symbol.getName().endsWith(".")) {
                    Object[] objectArray = RT.toArray((Object)RT.next((Object)object5));
                    return Reflector.invokeConstructor((Class)RT.classForName((String)symbol.getName().substring(0, symbol.getName().length() - 1)), (Object[])objectArray);
                }
                if (Compiler.namesStaticMember((Symbol)symbol)) {
                    Object[] objectArray = RT.toArray((Object)RT.next((Object)object5));
                    return Reflector.invokeStaticMethod((String)symbol.getNamespace(), (String)symbol.getName(), (Object[])objectArray);
                }
                Object object6 = Compiler.maybeResolveIn((Namespace)LispReader.currentNS(), (Symbol)symbol);
                if (object6 instanceof Var) {
                    return ((IFn)object6).applyTo(RT.next((Object)object5));
                }
                throw Util.runtimeException((String)("Can't resolve " + String.valueOf(symbol)));
            }
            throw new IllegalArgumentException("Unsupported #= form");
        }
    }

    public static class UnreadableReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            throw Util.runtimeException((String)"Unreadable form");
        }
    }

    public static class DiscardReader
    extends AFn {
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            PushbackReader pushbackReader = (PushbackReader)object;
            LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            return pushbackReader;
        }
    }

    public static class ConditionalReader
    extends AFn {
        private static final Object READ_STARTED = new Object();
        public static final Keyword DEFAULT_FEATURE = Keyword.intern(null, (String)"default");
        public static final IPersistentSet RESERVED_FEATURES = RT.set((Object[])new Object[]{Keyword.intern(null, (String)"else"), Keyword.intern(null, (String)"none")});

        public static boolean hasFeature(Object object, Object object2) {
            if (!(object instanceof Keyword)) {
                throw Util.runtimeException((String)("Feature should be a keyword: " + String.valueOf(object)));
            }
            if (DEFAULT_FEATURE.equals(object)) {
                return true;
            }
            IPersistentSet iPersistentSet = (IPersistentSet)((IPersistentMap)object2).valAt((Object)OPT_FEATURES);
            return iPersistentSet != null && iPersistentSet.contains(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object readCondDelimited(PushbackReader pushbackReader, boolean bl, Object object, Object object2) {
            int n;
            Object object3 = READ_STARTED;
            boolean bl2 = object2 == null;
            object2 = LispReader.ensurePending(object2);
            int n2 = n = pushbackReader instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)pushbackReader).getLineNumber() : -1;
            while (true) {
                Object object4;
                if (object3 == READ_STARTED) {
                    object4 = LispReader.read(pushbackReader, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, object, object2, null);
                    if (object4 == READ_EOF) {
                        if (n < 0) {
                            throw Util.runtimeException((String)"EOF while reading");
                        }
                        throw Util.runtimeException((String)("EOF while reading, starting at line " + n));
                    }
                    if (object4 == READ_FINISHED) break;
                    if (RESERVED_FEATURES.contains(object4)) {
                        throw Util.runtimeException((String)("Feature name " + String.valueOf(object4) + " is reserved."));
                    }
                    if (ConditionalReader.hasFeature(object4, object)) {
                        object4 = LispReader.read(pushbackReader, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, object, object2, (Resolver)READER_RESOLVER.deref());
                        if (object4 == READ_EOF) {
                            if (n < 0) {
                                throw Util.runtimeException((String)"EOF while reading");
                            }
                            throw Util.runtimeException((String)("EOF while reading, starting at line " + n));
                        }
                        if (object4 == READ_FINISHED) {
                            if (n < 0) {
                                throw Util.runtimeException((String)"read-cond requires an even number of forms.");
                            }
                            throw Util.runtimeException((String)("read-cond starting on line " + n + " requires an even number of forms"));
                        }
                        object3 = object4;
                    }
                }
                try {
                    Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{RT.SUPPRESS_READ, RT.T}));
                    object4 = LispReader.read(pushbackReader, false, READ_EOF, Character.valueOf(')'), READ_FINISHED, true, object, object2, (Resolver)READER_RESOLVER.deref());
                    if (object4 == READ_EOF) {
                        if (n < 0) {
                            throw Util.runtimeException((String)"EOF while reading");
                        }
                        throw Util.runtimeException((String)("EOF while reading, starting at line " + n));
                    }
                    if (object4 != READ_FINISHED) continue;
                }
                finally {
                    Var.popThreadBindings();
                    continue;
                }
                break;
            }
            if (object3 == READ_STARTED) {
                return pushbackReader;
            }
            if (bl) {
                if (!(object3 instanceof List)) {
                    throw Util.runtimeException((String)"Spliced form list in read-cond-splicing must implement java.util.List");
                }
                if (bl2) {
                    throw Util.runtimeException((String)"Reader conditional splicing not allowed at the top level.");
                }
                ((List)object2).addAll(0, (List)object3);
                return pushbackReader;
            }
            return object3;
        }

        private static void checkConditionalAllowed(Object object) {
            IPersistentMap iPersistentMap = (IPersistentMap)object;
            if (object == null || !COND_ALLOW.equals(iPersistentMap.valAt((Object)OPT_READ_COND)) && !COND_PRESERVE.equals(iPersistentMap.valAt((Object)OPT_READ_COND))) {
                throw Util.runtimeException((String)"Conditional read not allowed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            ConditionalReader.checkConditionalAllowed(object3);
            PushbackReader pushbackReader = (PushbackReader)object;
            int n = LispReader.read1(pushbackReader);
            if (n == -1) {
                throw Util.runtimeException((String)"EOF while reading character");
            }
            boolean bl = false;
            if (n == 64) {
                bl = true;
                n = LispReader.read1(pushbackReader);
            }
            while (LispReader.isWhitespace(n)) {
                n = LispReader.read1(pushbackReader);
            }
            if (n == -1) {
                throw Util.runtimeException((String)"EOF while reading character");
            }
            if (n != 40) {
                throw Util.runtimeException((String)"read-cond body must be a list");
            }
            try {
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{READ_COND_ENV, RT.T}));
                if (LispReader.isPreserveReadCond(object3)) {
                    IFn iFn = LispReader.getMacro(n);
                    Object object5 = iFn.invoke((Object)pushbackReader, (Object)n, object3, LispReader.ensurePending(object4));
                    ReaderConditional readerConditional = ReaderConditional.create((Object)object5, (boolean)bl);
                    return readerConditional;
                }
                Object object6 = ConditionalReader.readCondDelimited(pushbackReader, bl, object3, object4);
                return object6;
            }
            finally {
                Var.popThreadBindings();
            }
        }
    }

    public static class NamespaceMapReader
    extends AFn {
        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            Object object5;
            Object[] objectArray;
            String string;
            Object object6;
            PushbackReader pushbackReader = (PushbackReader)object;
            boolean bl = false;
            int n = LispReader.read1(pushbackReader);
            if (n == 58) {
                bl = true;
            } else {
                LispReader.unread(pushbackReader, n);
            }
            Object object7 = null;
            int n2 = LispReader.read1(pushbackReader);
            if (LispReader.isWhitespace(n2)) {
                if (!bl) {
                    LispReader.unread(pushbackReader, n2);
                    throw Util.runtimeException((String)"Namespaced map must specify a namespace");
                }
                while (LispReader.isWhitespace(n2)) {
                    n2 = LispReader.read1(pushbackReader);
                }
                if (n2 != 123) {
                    LispReader.unread(pushbackReader, n2);
                    throw Util.runtimeException((String)"Namespaced map must specify a namespace");
                }
            } else if (n2 != 123) {
                LispReader.unread(pushbackReader, n2);
                object7 = LispReader.read(pushbackReader, true, null, false, object3, object4);
                n2 = LispReader.read1(pushbackReader);
                while (LispReader.isWhitespace(n2)) {
                    n2 = LispReader.read1(pushbackReader);
                }
            }
            if (n2 != 123) {
                throw Util.runtimeException((String)"Namespaced map must specify a map");
            }
            if (bl) {
                object6 = (Resolver)READER_RESOLVER.deref();
                if (object7 == null) {
                    string = object6 != null ? object6.currentNS().getName() : LispReader.currentNS().getName().getName();
                } else {
                    if (!(object7 instanceof Symbol) || ((Symbol)object7).getNamespace() != null) {
                        throw Util.runtimeException((String)("Namespaced map must specify a valid namespace: " + String.valueOf(object7)));
                    }
                    if (object6 != null) {
                        objectArray = object6.resolveAlias((Symbol)object7);
                    } else {
                        object5 = LispReader.currentNS().lookupAlias((Symbol)object7);
                        Object[] objectArray2 = objectArray = object5 != null ? object5.getName() : null;
                    }
                    if (objectArray == null) {
                        throw Util.runtimeException((String)("Unknown auto-resolved namespace alias: " + String.valueOf(object7)));
                    }
                    string = objectArray.getName();
                }
            } else {
                if (!(object7 instanceof Symbol) || ((Symbol)object7).getNamespace() != null) {
                    throw Util.runtimeException((String)("Namespaced map must specify a valid namespace: " + String.valueOf(object7)));
                }
                string = ((Symbol)object7).getName();
            }
            object6 = LispReader.readDelimitedList('}', pushbackReader, true, object3, LispReader.ensurePending(object4));
            if ((object6.size() & 1) == 1) {
                throw Util.runtimeException((String)"Namespaced map literal must contain an even number of forms");
            }
            objectArray = new Object[object6.size()];
            object5 = object6.iterator();
            int n3 = 0;
            while (true) {
                void var15_15;
                Object e;
                block31: {
                    Keyword keyword;
                    Object e2;
                    block30: {
                        if (!object5.hasNext()) {
                            return RT.map((Object[])objectArray);
                        }
                        e2 = object5.next();
                        e = object5.next();
                        if (!(e2 instanceof Keyword)) break block30;
                        keyword = (Keyword)e2;
                        if (keyword.getNamespace() == null) {
                            Keyword keyword2 = Keyword.intern((String)string, (String)keyword.getName());
                            break block31;
                        } else if (keyword.getNamespace().equals("_")) {
                            Keyword keyword3 = Keyword.intern(null, (String)keyword.getName());
                        }
                        break block31;
                    }
                    if (e2 instanceof Symbol) {
                        keyword = (Symbol)e2;
                        if (keyword.getNamespace() == null) {
                            Symbol symbol = Symbol.intern((String)string, (String)keyword.getName());
                        } else if (keyword.getNamespace().equals("_")) {
                            Symbol symbol = Symbol.intern(null, (String)keyword.getName());
                        }
                    }
                }
                objectArray[n3] = var15_15;
                objectArray[n3 + 1] = e;
                n3 += 2;
            }
        }
    }

    public static class DeprecatedWrappingReader
    extends AFn {
        final Symbol sym;
        final String macro;

        public DeprecatedWrappingReader(Symbol symbol, String string) {
            this.sym = symbol;
            this.macro = string;
        }

        public Object invoke(Object object, Object object2, Object object3, Object object4) {
            System.out.println("WARNING: reader macro " + this.macro + " is deprecated; use " + this.sym.getName() + " instead");
            PushbackReader pushbackReader = (PushbackReader)object;
            Object object5 = LispReader.read(pushbackReader, true, null, true, object3, LispReader.ensurePending(object4));
            return RT.list((Object)this.sym, (Object)object5);
        }
    }
}

