(ns clotool.smacalalag.scraping.xmlhelper
  (:import [java.io StringReader StringWriter]
           [javax.xml.transform TransformerFactory OutputKeys]
           [javax.xml.transform.stream StreamSource StreamResult])
  (:require [hiccup.core :as hiccup]
            [clojure.java.io :as io]))

(defn- xml-escape
  [value]
  (str "<![CDATA[" value "]]>"))

(defn create-xml
  [xml-file jobs]
  (let [xml-data [:jobs
                  (for [job jobs]
                    [:job
                     [:id             (xml-escape job :id)]
                     [:script         (xml-escape job :script)]
                     [:link           (xml-escape job :link)]
                     [:description    (xml-escape job :description)]
                     [:job_title      (xml-escape job :job_title)]
                     [:job_type       (xml-escape job :job_type)]
                     [:created        (xml-escape job :created)]
                     [:salary         (xml-escape job :salary)]
                     [:ref            (xml-escape job :ref)]
                     [:close_date     (xml-escape job :close_date)]
                     [:html           (hiccup/h job :html)]
                     [:contact_name   (xml-escape job :contact_name)]
                     [:contact_title  (xml-escape job :contact_title)]
                     [:contact_tel    (xml-escape job :contact_tel)]
                     [:contact_email  (xml-escape job :contact_email)]
                     [:country        (xml-escape job :country)]
                     [:location       (xml-escape job :location)]
                     [:advref         (xml-escape job :advref)]
                     [:sect_1         (xml-escape job :sect_1)]
                     [:sect_2         (xml-escape job :sect_2)]
                     [:sect_3         (xml-escape job :sect_3)]
                     [:agencies       (xml-escape job :agencies)]])]]
    (with-open [out-file (io/writer xml-file)]
      (.write out-file (ppxml (hiccup/html xml-data))))))

(defn ppxml
  [xml-str]
  (let [in  (StreamSource. (StringReader. xml-str))
        out (StreamResult. (StringWriter.))
        transformer (.newTransformer
                      (TransformerFactory/newInstance))]
    (doseq [[prop val] {OutputKeys/INDENT "yes"
                        OutputKeys/METHOD "xml"
                        "{http://xml.apache.org/xslt}indent-amount" "2"}]
      (.setOutputProperty transformer prop val))
    (.transform transformer in out)
    (str (.getWriter out))))
