/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class FileUtils {
    private FileUtils() {
    }

    public static byte[] readFile(String fileName) {
        File file2 = new File(fileName);
        return FileUtils.readFile(file2);
    }

    public static byte[] readFile(File file2) {
        if (!file2.exists()) {
            throw new RuntimeException(file2 + ": file not found");
        }
        if (!file2.isFile()) {
            throw new RuntimeException(file2 + ": not a file");
        }
        if (!file2.canRead()) {
            throw new RuntimeException(file2 + ": file not readable");
        }
        long longLength = file2.length();
        int length = (int)longLength;
        if ((long)length != longLength) {
            throw new RuntimeException(file2 + ": file too long");
        }
        byte[] result = new byte[length];
        try {
            FileInputStream in = new FileInputStream(file2);
            int at = 0;
            while (length > 0) {
                int amt = in.read(result, at, length);
                if (amt == -1) {
                    throw new RuntimeException(file2 + ": unexpected EOF");
                }
                at += amt;
                length -= amt;
            }
            in.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(file2 + ": trouble reading", ex);
        }
        return result;
    }

    public static boolean hasArchiveSuffix(String fileName) {
        return fileName.endsWith(".zip") || fileName.endsWith(".jar") || fileName.endsWith(".apk");
    }
}

