/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import android.util.Log;
import clojure.lang.DynamicClassLoader;
import clojure.lang.RT;
import clojure.lang.Var;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DalvikDynamicClassLoader
extends DynamicClassLoader {
    private static final CfOptions OPTIONS = new CfOptions();
    private static final Var COMPILE_PATH = RT.var("clojure.core", "*compile-path*");
    private static final DexOptions DEX_OPTIONS = new DexOptions();
    private static final String TAG = "DalvikClojureCompiler";

    public DalvikDynamicClassLoader() {
    }

    public DalvikDynamicClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> defineMissingClass(String name2, byte[] bytes2, Object srcForm) {
        com.android.dx.dex.file.DexFile outDexFile = new com.android.dx.dex.file.DexFile(DEX_OPTIONS);
        DirectClassFile cf = new DirectClassFile(bytes2, DalvikDynamicClassLoader.asFilePath(name2), false);
        cf.setAttributeFactory(StdAttributeFactory.THE_ONE);
        outDexFile.add(CfTranslator.translate(cf, bytes2, OPTIONS, DEX_OPTIONS, outDexFile));
        File compileDir = new File((String)COMPILE_PATH.deref());
        try {
            File tmpDexFile = File.createTempFile("repl-", ".dex", compileDir);
            FileOutputStream fos = new FileOutputStream(tmpDexFile);
            outDexFile.writeTo(fos, null, false);
            fos.close();
            File optDexFile = new File(compileDir, tmpDexFile.getName().replace("repl-", "repl-opt-"));
            DexFile inDexFile = DexFile.loadDex((String)tmpDexFile.getAbsolutePath(), (String)optDexFile.getAbsolutePath(), (int)0);
            Class clazz = inDexFile.loadClass(name2.replace(".", "/"), (ClassLoader)this);
            if (clazz == null) {
                Log.e((String)TAG, (String)("Failed to load generated class: " + name2));
                throw new RuntimeException("Failed to load generated class " + name2 + ".");
            }
            return clazz;
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"Failed to define class due to I/O exception.", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    private static String asFilePath(String name2) {
        return name2.replace('.', '/').concat(".class");
    }

    static {
        DalvikDynamicClassLoader.OPTIONS.strictNameCheck = false;
        DalvikDynamicClassLoader.DEX_OPTIONS.targetApiLevel = 13;
    }
}

