/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.type;

import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import java.util.HashMap;

public final class Prototype
implements Comparable<Prototype> {
    private static final HashMap<String, Prototype> internTable = new HashMap(500);
    private final String descriptor;
    private final Type returnType;
    private final StdTypeList parameterTypes;
    private StdTypeList parameterFrameTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prototype intern(String descriptor2) {
        Prototype result;
        if (descriptor2 == null) {
            throw new NullPointerException("descriptor == null");
        }
        HashMap<String, Prototype> hashMap = internTable;
        synchronized (hashMap) {
            result = internTable.get(descriptor2);
        }
        if (result != null) {
            return result;
        }
        Type[] params = Prototype.makeParameterArray(descriptor2);
        int paramCount = 0;
        int at = 1;
        while (true) {
            int startAt = at;
            char c = descriptor2.charAt(at);
            if (c == ')') break;
            while (c == '[') {
                c = descriptor2.charAt(++at);
            }
            if (c == 'L') {
                int endAt = descriptor2.indexOf(59, at);
                if (endAt == -1) {
                    throw new IllegalArgumentException("bad descriptor");
                }
                at = endAt + 1;
            } else {
                ++at;
            }
            params[paramCount] = Type.intern(descriptor2.substring(startAt, at));
            ++paramCount;
        }
        Type returnType = Type.internReturnType(descriptor2.substring(++at));
        StdTypeList parameterTypes = new StdTypeList(paramCount);
        for (int i = 0; i < paramCount; ++i) {
            parameterTypes.set(i, params[i]);
        }
        result = new Prototype(descriptor2, returnType, parameterTypes);
        return Prototype.putIntern(result);
    }

    private static Type[] makeParameterArray(String descriptor2) {
        int length = descriptor2.length();
        if (descriptor2.charAt(0) != '(') {
            throw new IllegalArgumentException("bad descriptor");
        }
        int closeAt = 0;
        int maxParams = 0;
        for (int i = 1; i < length; ++i) {
            char c = descriptor2.charAt(i);
            if (c == ')') {
                closeAt = i;
                break;
            }
            if (c < 'A' || c > 'Z') continue;
            ++maxParams;
        }
        if (closeAt == 0 || closeAt == length - 1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        if (descriptor2.indexOf(41, closeAt + 1) != -1) {
            throw new IllegalArgumentException("bad descriptor");
        }
        return new Type[maxParams];
    }

    public static Prototype intern(String descriptor2, Type definer, boolean isStatic, boolean isInit) {
        Prototype base = Prototype.intern(descriptor2);
        if (isStatic) {
            return base;
        }
        if (isInit) {
            definer = definer.asUninitialized(Integer.MAX_VALUE);
        }
        return base.withFirstParameter(definer);
    }

    public static Prototype internInts(Type returnType, int count2) {
        StringBuffer sb = new StringBuffer(100);
        sb.append('(');
        for (int i = 0; i < count2; ++i) {
            sb.append('I');
        }
        sb.append(')');
        sb.append(returnType.getDescriptor());
        return Prototype.intern(sb.toString());
    }

    private Prototype(String descriptor2, Type returnType, StdTypeList parameterTypes) {
        if (descriptor2 == null) {
            throw new NullPointerException("descriptor == null");
        }
        if (returnType == null) {
            throw new NullPointerException("returnType == null");
        }
        if (parameterTypes == null) {
            throw new NullPointerException("parameterTypes == null");
        }
        this.descriptor = descriptor2;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.parameterFrameTypes = null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Prototype)) {
            return false;
        }
        return this.descriptor.equals(((Prototype)other).descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    @Override
    public int compareTo(Prototype other) {
        if (this == other) {
            return 0;
        }
        int result = this.returnType.compareTo(other.returnType);
        if (result != 0) {
            return result;
        }
        int thisSize = this.parameterTypes.size();
        int otherSize = other.parameterTypes.size();
        int size = Math.min(thisSize, otherSize);
        for (int i = 0; i < size; ++i) {
            Type otherType;
            Type thisType = this.parameterTypes.get(i);
            result = thisType.compareTo(otherType = other.parameterTypes.get(i));
            if (result == 0) continue;
            return result;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        if (thisSize > otherSize) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.descriptor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public StdTypeList getParameterTypes() {
        return this.parameterTypes;
    }

    public StdTypeList getParameterFrameTypes() {
        if (this.parameterFrameTypes == null) {
            int sz = this.parameterTypes.size();
            StdTypeList list = new StdTypeList(sz);
            boolean any = false;
            for (int i = 0; i < sz; ++i) {
                Type one = this.parameterTypes.get(i);
                if (one.isIntlike()) {
                    any = true;
                    one = Type.INT;
                }
                list.set(i, one);
            }
            this.parameterFrameTypes = any ? list : this.parameterTypes;
        }
        return this.parameterFrameTypes;
    }

    public Prototype withFirstParameter(Type param) {
        String newDesc = "(" + param.getDescriptor() + this.descriptor.substring(1);
        StdTypeList newParams = this.parameterTypes.withFirst(param);
        newParams.setImmutable();
        Prototype result = new Prototype(newDesc, this.returnType, newParams);
        return Prototype.putIntern(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Prototype putIntern(Prototype desc) {
        HashMap<String, Prototype> hashMap = internTable;
        synchronized (hashMap) {
            String descriptor2 = desc.getDescriptor();
            Prototype already = internTable.get(descriptor2);
            if (already != null) {
                return already;
            }
            internTable.put(descriptor2, desc);
            return desc;
        }
    }
}

