/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import android.os.Build;
import android.util.Log;
import clojure.lang.DynamicClassLoader;
import clojure.lang.RT;
import clojure.lang.Var;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import dalvik.system.DexFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DalvikDynamicClassLoader
extends DynamicClassLoader {
    private static final CfOptions OPTIONS = new CfOptions();
    private static final Var COMPILE_PATH = RT.var("clojure.core", "*compile-path*");
    private static final DexOptions DEX_OPTIONS = new DexOptions();
    private static final String TAG = "DalvikClojureCompiler";

    public DalvikDynamicClassLoader() {
    }

    public DalvikDynamicClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> defineMissingClass(String name, byte[] bytes, Object srcForm) {
        com.android.dx.dex.file.DexFile outDexFile = new com.android.dx.dex.file.DexFile(DEX_OPTIONS);
        outDexFile.add(CfTranslator.translate((String)"", (byte[])bytes, (CfOptions)OPTIONS, (DexOptions)DEX_OPTIONS));
        File compileDir = new File((String)COMPILE_PATH.deref());
        try {
            File jarFile = File.createTempFile("repl-", ".jar", compileDir);
            jarFile.deleteOnExit();
            ZipOutputStream jarOut = new ZipOutputStream(new FileOutputStream(jarFile));
            jarOut.putNextEntry(new ZipEntry("classes.dex"));
            outDexFile.writeTo((OutputStream)jarOut, null, false);
            jarOut.close();
            String jarPath = jarFile.getAbsolutePath();
            String dexPath = jarPath.substring(0, jarPath.lastIndexOf(46)).concat(".dex");
            DexFile inDexFile = DexFile.loadDex((String)jarPath, (String)dexPath, (int)0);
            Class clazz = inDexFile.loadClass(name.replace(".", "/"), (ClassLoader)this);
            if (clazz == null) {
                Log.e((String)TAG, (String)("Failed to load generated class: " + name));
                throw new RuntimeException("Failed to load generated class " + name + ".");
            }
            return clazz;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Failed to define class due to I/O exception.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        DalvikDynamicClassLoader.OPTIONS.strictNameCheck = false;
        DalvikDynamicClassLoader.DEX_OPTIONS.targetApiLevel = Build.VERSION.SDK_INT;
    }
}

