(ns cjd.vox.voxindex
  (:use
    [cjd.vox.vocalizer]
    [cjd.core-artifacts]
    [cjd.artifact-base]
    
    
    ))


(defn make-voxindex [ns-artifacts dest-file source-name source-title root-terms base-uri]
  (let [art-entries 
        (reduce 
          (fn [entries+ artifact]
            (let [aname (name (artifact-name-of artifact))
                  ans (artifact-name-of (namespace-of artifact))]
              (if (has-doc? artifact)
                (conj entries+ [(vec (id-vocalizer aname)) aname (str ans ".html#" aname)] )
                entries+)))
          []
          (sort-by artifact-name-of (mapcat artifacts-of ns-artifacts)))
        
        ns-entries 
        (reduce 
          (fn [ns-ents+ ns-art]
            (let [nsname (name (artifact-name-of ns-art))]
              (if (or (has-doc? ns-art) (some has-doc? (artifacts-of ns-art)))
                (conj ns-ents+ [(vec (id-vocalizer nsname)) nsname (str nsname ".html")])
                ns-ents+)))
          []
          (sort-by artifact-name-of ns-artifacts))
        
        the-map
        { :source-name source-name
          :source-title source-title
          :source-uri base-uri
          :indexes [ { 
            :name source-name
            :description source-title
            :root-terms root-terms
            :root-doc-uri "index.html"
            :specs [
              { :category "Overview" :prefix-terms nil
               :entries [[["overview" "summary"] "Overview" "index.html"]] }
              { :category "Namespaces" :prefix-terms nil :entries ns-entries }
              { :category "Artifacts" :prefix-terms nil :entries art-entries }
             ]
            }]}
        ]
    (if dest-file
      (spit dest-file 
            (->
              (prn-str the-map)
              (.replaceAll "\\] \\[\\[" "]\n    [[")
              (.replaceAll "\\{" "\n    {")
              (.replaceAll "\\}" "}\n    "))))
    the-map
    ))