(ns cjd.parse-test
  (:use 
    [clojure.test]
    [cjd.parser]
    [cjd.extractor]
    [cjd.precis]
    [cjd.core-elements]
    )
  (:import 
    [cjd.core_elements 
     Bold Italic Code SmallCaps Superscript Subscript Underline 
     Name NameSpace NameUse Link LinkTo Form Function 
     Text Paragraph FlowContainer
     SeeAlso Since Deprecation Author
     Argument Field Option Return ]
    )
  )


(defn ! 
  ([cjd-doc] (! true cjd-doc)) 
  ([with-text cjd-doc]
    (let [ast (parse-comment { :name 'test :ns 'foo.poo :level 1 } 
                           (forms-from-string cjd-doc))]
      (make-precis with-text ast))))

(defn !! [cjd-doc] (! false cjd-doc))


(deftest para 
  (is (= (!! "xxx yyy") 
         '[(p (x))]))
  (is (= (!! "@p xxx ttt") 
         '[(p (x))]))
  (is (= (!! "@(p xxx ttt)") 
         '[(p (x))]))
  (is (= (!! "xxx yyy @p zzz") 
         '[(p (x))(p (x))]))
  (is (= (!! "@p xxx ttt @p aaa bbb") 
         '[(p (x))(p (x))]))
  (is (= (!! "@(p xxx ttt) @p qqqe eee.") 
         '[(p (x))(p (x))]))
  (is (= (!! "@(p xxx ttt) @(p qqqe eee.)") 
         '[(p (x))(p (x))]))
  )

(deftest arg
  (is (= (!! "@arg aaa xxx yyy") 
         '[(arg aaa (p (x)))]))
  
  )

(deftest rv
  (is (= (!! "@returns xxx yyy zzz") 
         '[(returns (p (x)))]))
  (is (= (!! "@(returns xxx yyy zzz)") 
         '[(returns (p (x)))]))
  (is (= (!! "@(returns xxx yyy) zzz") 
         '[(returns (p (x))) (p (x))]))
  (is (= (!! "@p qqq rr ss @(returns xxx yyy @p aaa bbb) zzz") 
         '[(p (x)) (returns (p (x)) (p (x))) (p (x))]))
  )

(deftest mix 
  (is (= (!! "Lorem ipsum dolor sit amet. 
@p Consectetuer adipiscing elit, sed diam.
@(p Nonummy nibh euismod tincidunt)
@arg nono ut laoreet dolore magna 
@(arg aliquam erat volutpat)
@(return Ut wisi enim ad minim.
  @p veniam, quis nostrud exerci tation 
  @p ullamcorper suscipit.
  @arg noodle lobortis nisl ut aliquip)
@see Nothing, move along."))
      '[(p (x))(p (x))(p (x)) (arg nono (p (x)))
       (arg aliquam (p (x))) (returns (p (x))(p (x))(p (x)) (arg noodle (p (x))))]))

(deftest flowtests (para) (arg))


