/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader;

public class TopicInfo
implements Comparable<TopicInfo> {
    private final String myName;
    private long myMessageCount = 0L;
    private final String myMessageType;
    private final String myMessageMd5Sum;
    private long myConnectionCount = 0L;

    public TopicInfo(String name, String type, String md5sum) {
        this.myName = name;
        this.myMessageType = type;
        this.myMessageMd5Sum = md5sum;
    }

    public String getName() {
        return this.myName;
    }

    public long getMessageCount() {
        return this.myMessageCount;
    }

    public void addToMessageCount(long count) {
        this.myMessageCount += count;
    }

    public String getMessageType() {
        return this.myMessageType;
    }

    public String getMessageMd5Sum() {
        return this.myMessageMd5Sum;
    }

    public long getConnectionCount() {
        return this.myConnectionCount;
    }

    public void incrementConnectionCount() {
        ++this.myConnectionCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicInfo topicInfo = (TopicInfo)o;
        if (this.myMessageCount != topicInfo.myMessageCount) {
            return false;
        }
        if (this.myConnectionCount != topicInfo.myConnectionCount) {
            return false;
        }
        if (!this.myName.equals(topicInfo.myName)) {
            return false;
        }
        return this.myMessageType.equals(topicInfo.myMessageType);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + (int)(this.myMessageCount ^ this.myMessageCount >>> 32);
        result = 31 * result + this.myMessageType.hashCode();
        result = 31 * result + this.myMessageMd5Sum.hashCode();
        result = 31 * result + (int)(this.myConnectionCount ^ this.myConnectionCount >>> 32);
        return result;
    }

    @Override
    public int compareTo(TopicInfo topicInfo) {
        return this.myName.compareTo(topicInfo.myName);
    }
}

