/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.records;

import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.records.Chunk;
import com.github.swrirobotics.bags.reader.records.Record;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class IndexData {
    private int myVersion;
    private int myConnectionId;
    private int myCount;
    private final List<Index> myIndexes = new ArrayList<Index>();
    private final Chunk myChunk;

    public IndexData(Record record, Chunk chunk) throws BagReaderException {
        this.myVersion = record.getHeader().getInt("ver");
        this.myConnectionId = record.getHeader().getInt("conn");
        this.myCount = record.getHeader().getInt("count");
        this.myChunk = chunk;
        ByteBuffer buffer = record.getData();
        for (int i = 0; i < this.myCount; ++i) {
            long secs = buffer.getInt();
            int nsecs = buffer.getInt();
            int offsetVal = buffer.getInt();
            this.myIndexes.add(new Index(secs, nsecs, offsetVal));
        }
    }

    public int getVersion() {
        return this.myVersion;
    }

    public int getConnectionId() {
        return this.myConnectionId;
    }

    public int getCount() {
        return this.myCount;
    }

    public Chunk getChunk() {
        return this.myChunk;
    }

    public List<Index> getIndexes() {
        return this.myIndexes;
    }

    public static class Index {
        private final Timestamp myTime;
        private final int myOffset;

        public Index(long secs, int nsecs, int offset) {
            this.myTime = new Timestamp(secs * 1000L);
            this.myTime.setNanos(nsecs);
            this.myOffset = offset;
        }

        public Timestamp getTime() {
            return this.myTime;
        }

        public int getOffset() {
            return this.myOffset;
        }
    }
}

