/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.records;

import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class Header {
    private final Map<String, Field> myFieldMap = Maps.newHashMap();
    private Record.RecordType myType = Record.RecordType.UNKNOWN;

    public Header() {
    }

    public Header(ByteBuffer buffer) throws BagReaderException {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        block8: while (buffer.hasRemaining()) {
            Field field = new Field(buffer);
            this.myFieldMap.put(field.getName(), field);
            if (!"op".equals(field.getName())) continue;
            byte firstByte = field.getFirstByte();
            switch (firstByte) {
                case 3: {
                    this.myType = Record.RecordType.BAG_HEADER;
                    continue block8;
                }
                case 5: {
                    this.myType = Record.RecordType.CHUNK;
                    continue block8;
                }
                case 7: {
                    this.myType = Record.RecordType.CONNECTION;
                    continue block8;
                }
                case 2: {
                    this.myType = Record.RecordType.MESSAGE_DATA;
                    continue block8;
                }
                case 4: {
                    this.myType = Record.RecordType.INDEX_DATA;
                    continue block8;
                }
                case 6: {
                    this.myType = Record.RecordType.CHUNK_INFO;
                    continue block8;
                }
            }
            throw new BagReaderException("Unknown op code in header: " + firstByte);
        }
    }

    public Record.RecordType getType() {
        return this.myType;
    }

    public String getValue(String fieldName) throws BagReaderException {
        Field field = this.myFieldMap.get(fieldName);
        this.checkFields(fieldName, field);
        return field.getString();
    }

    public int getInt(String fieldName) throws BagReaderException {
        Field field = this.myFieldMap.get(fieldName);
        this.checkFields(fieldName, field);
        return field.getInt();
    }

    public long getLong(String fieldName) throws BagReaderException {
        Field field = this.myFieldMap.get(fieldName);
        this.checkFields(fieldName, field);
        return field.getLong();
    }

    public Timestamp getTimestamp(String fieldName) throws BagReaderException {
        Field field = this.myFieldMap.get(fieldName);
        this.checkFields(fieldName, field);
        return field.getTimestamp();
    }

    private void checkFields(String fieldName, Field field) throws BagReaderException {
        if (field == null) {
            String fieldstr = Joiner.on((char)',').join(this.myFieldMap.keySet());
            throw new BagReaderException("Unknown field: " + fieldName + "; valid fields are: " + fieldstr);
        }
    }

    private static class Field {
        private final int myLength;
        private String myName;
        private byte[] myValue;
        private boolean myGotInt = false;
        private int myIntValue = 0;
        private boolean myGotLong = false;
        private long myLongValue = 0L;
        private String myStringValue = null;
        private Timestamp myTimestampValue = null;

        public Field(ByteBuffer buffer) throws BagReaderException {
            this.myLength = buffer.getInt();
            if ((long)this.myLength > 100000L) {
                throw new BagReaderException("Header field is unreasonably large (" + this.myLength + " bytes).  Bag file may need to be reindexed.");
            }
            byte[] fieldData = new byte[this.myLength];
            buffer.get(fieldData);
            fieldData = ByteBuffer.wrap(fieldData).order(ByteOrder.LITTLE_ENDIAN).array();
            int separatorPos = -1;
            for (int i = 0; i < fieldData.length; ++i) {
                if (fieldData[i] != 61) continue;
                separatorPos = i;
                break;
            }
            if (separatorPos <= -1) {
                throw new BagReaderException("Unable to find separator in header.");
            }
            this.myName = new String(Arrays.copyOfRange(fieldData, 0, separatorPos));
            this.myValue = Arrays.copyOfRange(fieldData, separatorPos + 1, fieldData.length);
        }

        public int getLength() {
            return this.myLength;
        }

        public String getName() {
            return this.myName;
        }

        public int getInt() {
            if (!this.myGotInt) {
                this.myIntValue = ByteBuffer.wrap(this.myValue).order(ByteOrder.LITTLE_ENDIAN).getInt();
                this.myGotInt = true;
            }
            return this.myIntValue;
        }

        public long getLong() {
            if (!this.myGotLong) {
                this.myLongValue = ByteBuffer.wrap(this.myValue).order(ByteOrder.LITTLE_ENDIAN).getLong();
                this.myGotLong = true;
            }
            return this.myLongValue;
        }

        public byte getFirstByte() {
            return this.myValue[0];
        }

        public String getString() {
            if (this.myStringValue == null) {
                this.myStringValue = new String(this.myValue);
            }
            return this.myStringValue;
        }

        public Timestamp getTimestamp() {
            if (this.myTimestampValue == null) {
                ByteBuffer buffer = ByteBuffer.wrap(this.myValue).order(ByteOrder.LITTLE_ENDIAN);
                long secs = buffer.getInt();
                int nsecs = buffer.getInt();
                this.myTimestampValue = new Timestamp(secs * 1000L);
                this.myTimestampValue.setNanos(nsecs);
            }
            return this.myTimestampValue;
        }
    }
}

