/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.messages.serialization;

import com.github.swrirobotics.bags.reader.ByteBufferChannel;
import com.github.swrirobotics.bags.reader.exceptions.BagReaderException;
import com.github.swrirobotics.bags.reader.exceptions.UnknownMessageException;
import com.github.swrirobotics.bags.reader.messages.serialization.BagMessage;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageCollection;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import com.github.swrirobotics.bags.reader.records.ChunkInfo;
import com.github.swrirobotics.bags.reader.records.ChunkRecordIterator;
import com.github.swrirobotics.bags.reader.records.Connection;
import com.github.swrirobotics.bags.reader.records.Header;
import com.github.swrirobotics.bags.reader.records.Record;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgIterator
implements Iterator<BagMessage> {
    private final SeekableByteChannel myInput;
    private final List<ChunkInfo> myChunkInfos;
    private Connection myCurrentConn = null;
    private ByteBufferChannel currentBuffer = null;
    private ChunkRecordIterator chunkIter = null;
    private BagMessage nextMsg = null;
    private HashMap<Integer, Connection> myConnections = new HashMap();
    private static final Logger myLogger = LoggerFactory.getLogger(MsgIterator.class);

    public MsgIterator(List<ChunkInfo> chunkInfos, Connection connId, SeekableByteChannel input) {
        this(chunkInfos, Lists.newArrayList((Object[])new Connection[]{connId}), input);
    }

    public MsgIterator(List<ChunkInfo> chunkInfos, List<Connection> conns, SeekableByteChannel input) {
        for (Connection conn : conns) {
            Integer connId = conn.getConnectionId();
            this.myConnections.put(connId, conn);
        }
        this.myInput = input;
        this.myChunkInfos = chunkInfos;
    }

    @Override
    public boolean hasNext() {
        if (this.nextMsg == null) {
            this.nextMsg = this.findNext();
        }
        return this.nextMsg != null;
    }

    @Override
    public BagMessage next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextMsg != null) {
            BagMessage tmp = this.nextMsg;
            this.nextMsg = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    private BagMessage findNext() {
        if (this.currentBuffer == null) {
            if (this.chunkIter != null && this.chunkIter.hasNext()) {
                Record nextChunk = this.chunkIter.next();
                try {
                    this.currentBuffer = new ByteBufferChannel(nextChunk.getData());
                }
                catch (BagReaderException e) {
                    myLogger.error("Error reading chunk:", (Throwable)e);
                    return null;
                }
            } else {
                if (this.chunkIter == null) {
                    this.chunkIter = new ChunkRecordIterator(this.myConnections.keySet(), this.myInput, this.myChunkInfos);
                    return this.findNext();
                }
                return null;
            }
        }
        try {
            while (this.currentBuffer.position() < this.currentBuffer.size()) {
                Record record = new Record(this.currentBuffer);
                Header header = record.getHeader();
                int connId = header.getInt("conn");
                if (header.getType() != Record.RecordType.MESSAGE_DATA || !this.myConnections.containsKey(connId)) continue;
                ByteBuffer buf = record.getData().order(ByteOrder.LITTLE_ENDIAN);
                Connection conn = this.myConnections.get(connId);
                MessageCollection msg = conn.getMessageCollection();
                MessageType mt = msg.getMessageType();
                mt.reset();
                mt.readMessage(buf);
                return new BagMessage(conn.getTopic(), mt, header.getTimestamp("time"));
            }
        }
        catch (BagReaderException | UnknownMessageException | IOException | RuntimeException e) {
            myLogger.error("Error reading messages", (Throwable)e);
            return null;
        }
        this.currentBuffer = null;
        return this.findNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

