/*
 * Decompiled with CFR 0.152.
 */
package com.github.swrirobotics.bags.reader.messages.serialization;

import com.github.swrirobotics.bags.reader.exceptions.InvalidDefinitionException;
import com.github.swrirobotics.bags.reader.exceptions.UnknownMessageException;
import com.github.swrirobotics.bags.reader.messages.serialization.MessageType;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCollection {
    private final Map<String, MessageType> myMsgTypesByName = Maps.newHashMap();
    private final Map<String, Map<String, MessageType>> myMsgTypesByPackage = Maps.newHashMap();
    private final Map<String, MessageType> myMsgTypeByMd5Sum = Maps.newHashMap();
    private String myTopType = null;
    private final Splitter MSG_SPLITTER = Splitter.on((String)"================================================================================").trimResults().omitEmptyStrings();
    private static final Logger myLogger = LoggerFactory.getLogger(MessageCollection.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseMessages(String messages) throws InvalidDefinitionException {
        messages = "MSG: " + this.myTopType + "\n" + (String)messages;
        List msgList = this.MSG_SPLITTER.splitToList((CharSequence)messages);
        ListIterator<String> msgIter = msgList.listIterator(msgList.size());
        myLogger.debug("--- Starting message parsing for " + this.myTopType + " ---");
        try {
            List<String> unparsedMsgs = this.parseMessageList(msgIter);
            int unparsedCount = unparsedMsgs.size();
            while (unparsedCount != 0) {
                myLogger.debug("Couldn't parse some messages on the first pass; trying again.");
                unparsedMsgs = this.parseMessageList(unparsedMsgs.listIterator(unparsedMsgs.size()));
                if (unparsedMsgs.size() == unparsedCount) {
                    myLogger.error("Unable to parse some messages: " + Joiner.on((String)"====\n").skipNulls().join(unparsedMsgs));
                    throw new InvalidDefinitionException("Unable to parse " + unparsedCount + " messages.");
                }
                unparsedCount = unparsedMsgs.size();
            }
        }
        finally {
            myLogger.debug("--- Finished parsing messages ---");
        }
    }

    private List<String> parseMessageList(ListIterator<String> msgIter) throws InvalidDefinitionException {
        ArrayList unparseableMessages = Lists.newArrayList();
        while (msgIter.hasPrevious()) {
            String msgStr = msgIter.previous();
            try {
                MessageType msg = new MessageType(msgStr, this);
                myLogger.debug("Constructed deserializer for message type: [" + msg.getPackage() + "]/[" + msg.getType() + "]");
                this.myMsgTypesByName.put(msg.getType(), msg);
                HashMap pkgMap = this.myMsgTypesByPackage.get(msg.getPackage());
                if (pkgMap == null) {
                    pkgMap = Maps.newHashMap();
                    this.myMsgTypesByPackage.put(msg.getPackage(), pkgMap);
                }
                pkgMap.put(msg.getType(), msg);
                this.myMsgTypeByMd5Sum.put(msg.getMd5Sum(), msg);
            }
            catch (UnknownMessageException e) {
                unparseableMessages.add(msgStr);
            }
        }
        return unparseableMessages;
    }

    public void setTopType(String type) {
        this.myTopType = type;
    }

    MessageType getMessageType(String pkg, String name) throws UnknownMessageException {
        Map<String, MessageType> pkgMap = this.myMsgTypesByPackage.get(pkg);
        if (pkgMap == null) {
            throw new UnknownMessageException(pkg, "");
        }
        MessageType oldMt = pkgMap.get(name);
        if (oldMt == null) {
            throw new UnknownMessageException(pkg, name);
        }
        return oldMt.copy();
    }

    MessageType getMessageType(String name) throws UnknownMessageException {
        MessageType oldMt = this.myMsgTypesByName.get(name);
        if (oldMt == null) {
            throw new UnknownMessageException("[" + name + "]");
        }
        return oldMt.copy();
    }

    public MessageType getMessageType() throws UnknownMessageException {
        if (this.myTopType == null) {
            throw new UnknownMessageException("Unknown");
        }
        List types = Splitter.on((String)"/").trimResults().omitEmptyStrings().splitToList((CharSequence)this.myTopType);
        if (types.size() == 1) {
            return this.getMessageType((String)types.get(0));
        }
        return this.getMessageType((String)types.get(0), (String)types.get(1));
    }
}

