(ns org.candelbio.multitool.htrace
  (:require [clojure.tools.trace :as ctt]))

;;; Hierarchical tracer (after Common Lisp ctrace, link TODO)
;;; Incorporating code from clojure.tools.trace 

Representation. Really wish for mutable structure in this case. (transient )  might work
[(f args) calls value]


(defn ^{:private true} tracer
  "This function is called by trace. Prints to standard output, but
may be rebound to do anything you like. 'name' is optional."
  [name value]
  (println (str "HTRACE" (when name (str " " name)) ": " value)))







(defn ^{:skip-wiki true} trace-fn-call
  "Traces a single call to a function f with args. 'name' is the
symbol name of the function."
  [name f args]
  (let [id (gensym "t")]
    (tracer id (str (trace-indent) (pr-str (cons name args))))
    (let [value (binding [*trace-depth* (inc *trace-depth*)]
                  (apply f args))]
      (tracer id (str (trace-indent) "=> " (pr-str value)))
      value)))



(defn with-tracing [f]
  (binding [clojure.tools.trace/tracer mtracer]
    (f)))
