1(ns leiningen.skummet
   (:require [clojure.java.shell :as sh]
             [clojure.java.io :as jio]
             [leiningen.core.project :as pr]
             [leiningen.core.eval :as eval]
             [leiningen.core.main :as main]
             [leiningen.core.classpath :as cp]
             leiningen.clean
             leiningen.compile
             leiningen.run
             leiningen.uberjar))

(defn eval-in [project form]
  (binding [eval/*dir* (:root project)
            *err* nil]
    (apply eval/sh (eval/shell-command project form))))

(defn eval-in-project
  "Executes form in isolation with the classpath and compile path set correctly
  for the project. If the form depends on any requires, put them in the init arg
  to avoid the Gilardi Scenario: http://technomancy.us/143"
  ([project form init]
     (eval/prep project)
     (eval-in project
              `(do (set! ~'*warn-on-reflection*
                         ~(:warn-on-reflection project))
                   ~@(map (fn [[k v]] `(set! ~k ~v)) (:global-vars project))
                   ~init
                   ~@(:injections project)
                   ~form)))
  ([project form] (eval-in-project project form nil)))

(defn skummet
  [project & [subtask & args]]
  (cond
   (= subtask "compile")
   (do
     (leiningen.clean/clean project)
     (if-let [namespaces (cons 'clojure.core (seq (leiningen.compile/stale-namespaces project)))]
       (let [form `(let [not-lean-vars# #{"#'clojure.core/in-ns" "#'clojure.core/refer"
                                          "#'clojure.core/load-file" "#'clojure.core/load"
                                          "#'clojure.core/defn" "#'clojure.core/defmacro" "#'clojure.core/parents"
                                          "#'clojure.core/ancestors" "#'clojure.core/pr-on" "#'clojure.core/isa?"
                                          "#'clojure.core/global-hierarchy"
                                          "#'clojure.core/.."
                                          }
                         lean-var?# (fn [^clojure.lang.Var var]
                                      (and (not (not-lean-vars# (.toString var)))
                                           (not (.startsWith (.. var sym getName) "-"))))]
                     (push-thread-bindings {#'clojure.core/*loaded-libs* (ref (sorted-set))})
                     (try
                       (binding [~'*lean-var?* lean-var?#
                                 ~'*lean-compile* true
                                 *compiler-options* {:elide-meta [:doc :file :line :added :arglists :column :static :author :added]}]
                         (doseq [namespace# '~namespaces]
                           (println "Compiling" namespace#)
                           (clojure.core/compile namespace#)))
                       (finally (pop-thread-bindings))))
             project (update-in project [:prep-tasks]
                                (partial remove #{"compile"}))]
         (try (eval-in-project project form)
              (catch Exception e
                (main/abort "Compilation failed:" (.getMessage e)))))
       (main/debug "All namespaces already AOT compiled.")))

   (= subtask "run")
   (let [[basedep] (-> project
                       (assoc :dependencies '[[org.bytopia/clojure "1.7.0-leanbase-SNAPSHOT"]])
                       (->> (cp/resolve-dependencies :dependencies)))]
     (apply eval/sh "java" "-cp" (str (jio/file (:target-path project) "classes") ":" basedep)
            (str (:main project)) args))

   (= subtask "jar")
   (-> project
       (assoc :dependencies '[[org.bytopia/clojure "1.7.0-leanbase-SNAPSHOT"]])
       (leiningen.uberjar/uberjar))

   :else
   (main/abort "Wrong subtask:" subtask)))
