/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.Associative;
import clojure.lang.BigInt;
import clojure.lang.IFn;
import clojure.lang.ILookup;
import clojure.lang.IMapEntry;
import clojure.lang.IMeta;
import clojure.lang.IObj;
import clojure.lang.IPersistentMap;
import clojure.lang.IReference;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.Numbers;
import clojure.lang.PersistentHashSet;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Util;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EdnReader {
    static IFn[] macros = new IFn[256];
    static IFn[] dispatchMacros = new IFn[256];
    static Pattern symbolPat = Pattern.compile("[:]?([\\D&&[^/]].*/)?(/|[\\D&&[^/]][^/]*)");
    static Pattern intPat = Pattern.compile("([-+]?)(?:(0)|([1-9][0-9]*)|0[xX]([0-9A-Fa-f]+)|0([0-7]+)|([1-9][0-9]?)[rR]([0-9A-Za-z]+)|0[0-9]+)(N)?");
    static Pattern ratioPat = Pattern.compile("([-+]?[0-9]+)/([0-9]+)");
    static Pattern floatPat = Pattern.compile("([-+]?[0-9]+(\\.[0-9]*)?([eE][-+]?[0-9]+)?)(M)?");
    static IFn taggedReader = new TaggedReader();
    static final Keyword EOF;

    static boolean nonConstituent(int ch) {
        return ch == 64 || ch == 96 || ch == 126;
    }

    public static Object readString(String s, IPersistentMap opts) {
        PushbackReader r = new PushbackReader(new java.io.StringReader(s));
        return EdnReader.read(r, opts);
    }

    static boolean isWhitespace(int ch) {
        return Character.isWhitespace(ch) || ch == 44;
    }

    static void unread(PushbackReader r, int ch) {
        if (ch != -1) {
            try {
                r.unread(ch);
            }
            catch (IOException e) {
                throw Util.sneakyThrow(e);
            }
        }
    }

    public static int read1(Reader r) {
        try {
            return r.read();
        }
        catch (IOException e) {
            throw Util.sneakyThrow(e);
        }
    }

    public static Object read(PushbackReader r, IPersistentMap opts) {
        return EdnReader.read(r, !opts.containsKey(EOF), opts.valAt(EOF), false, opts);
    }

    public static Object read(PushbackReader r, boolean eofIsError, Object eofValue, boolean isRecursive, Object opts) {
        try {
            int ch;
            block13: {
                Object ret;
                do {
                    ch = EdnReader.read1(r);
                    while (EdnReader.isWhitespace(ch)) {
                        ch = EdnReader.read1(r);
                    }
                    if (ch == -1) {
                        if (eofIsError) {
                            throw Util.runtimeException("EOF while reading");
                        }
                        return eofValue;
                    }
                    if (Character.isDigit(ch)) {
                        Object n = EdnReader.readNumber(r, (char)ch);
                        if (RT.suppressRead()) {
                            return null;
                        }
                        return n;
                    }
                    IFn macroFn = EdnReader.getMacro(ch);
                    if (macroFn == null) break block13;
                    ret = macroFn.invoke(r, Character.valueOf((char)ch), opts);
                    if (!RT.suppressRead()) continue;
                    return null;
                } while (ret == r);
                return ret;
            }
            if (ch == 43 || ch == 45) {
                int ch2 = EdnReader.read1(r);
                if (Character.isDigit(ch2)) {
                    EdnReader.unread(r, ch2);
                    Object n = EdnReader.readNumber(r, (char)ch);
                    if (RT.suppressRead()) {
                        return null;
                    }
                    return n;
                }
                EdnReader.unread(r, ch2);
            }
            String token = EdnReader.readToken(r, (char)ch, true);
            if (RT.suppressRead()) {
                return null;
            }
            return EdnReader.interpretToken(token);
        }
        catch (Exception e) {
            if (isRecursive || !(r instanceof LineNumberingPushbackReader)) {
                throw Util.sneakyThrow(e);
            }
            LineNumberingPushbackReader rdr = (LineNumberingPushbackReader)r;
            throw new ReaderException(rdr.getLineNumber(), rdr.getColumnNumber(), e);
        }
    }

    private static String readToken(PushbackReader r, char initch, boolean leadConstituent) {
        StringBuilder sb = new StringBuilder();
        if (leadConstituent && EdnReader.nonConstituent(initch)) {
            throw Util.runtimeException("Invalid leading character: " + initch);
        }
        sb.append(initch);
        while (true) {
            int ch;
            if ((ch = EdnReader.read1(r)) == -1 || EdnReader.isWhitespace(ch) || EdnReader.isTerminatingMacro(ch)) {
                EdnReader.unread(r, ch);
                return sb.toString();
            }
            if (EdnReader.nonConstituent(ch)) {
                throw Util.runtimeException("Invalid constituent character: " + (char)ch);
            }
            sb.append((char)ch);
        }
    }

    private static Object readNumber(PushbackReader r, char initch) {
        int ch;
        StringBuilder sb = new StringBuilder();
        sb.append(initch);
        while (true) {
            if ((ch = EdnReader.read1(r)) == -1 || EdnReader.isWhitespace(ch) || EdnReader.isMacro(ch)) break;
            sb.append((char)ch);
        }
        EdnReader.unread(r, ch);
        String s = sb.toString();
        Object n = EdnReader.matchNumber(s);
        if (n == null) {
            throw new NumberFormatException("Invalid number: " + s);
        }
        return n;
    }

    private static int readUnicodeChar(String token, int offset, int length, int base) {
        if (token.length() != offset + length) {
            throw new IllegalArgumentException("Invalid unicode character: \\" + token);
        }
        int uc = 0;
        for (int i = offset; i < offset + length; ++i) {
            int d = Character.digit(token.charAt(i), base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + token.charAt(i));
            }
            uc = uc * base + d;
        }
        return (char)uc;
    }

    private static int readUnicodeChar(PushbackReader r, int initch, int base, int length, boolean exact) {
        int i;
        int uc = Character.digit(initch, base);
        if (uc == -1) {
            throw new IllegalArgumentException("Invalid digit: " + (char)initch);
        }
        for (i = 1; i < length; ++i) {
            int ch = EdnReader.read1(r);
            if (ch == -1 || EdnReader.isWhitespace(ch) || EdnReader.isMacro(ch)) {
                EdnReader.unread(r, ch);
                break;
            }
            int d = Character.digit(ch, base);
            if (d == -1) {
                throw new IllegalArgumentException("Invalid digit: " + (char)ch);
            }
            uc = uc * base + d;
        }
        if (i != length && exact) {
            throw new IllegalArgumentException("Invalid character length: " + i + ", should be: " + length);
        }
        return uc;
    }

    private static Object interpretToken(String s) {
        if (s.equals("nil")) {
            return null;
        }
        if (s.equals("true")) {
            return RT.T;
        }
        if (s.equals("false")) {
            return RT.F;
        }
        Object ret = null;
        ret = EdnReader.matchSymbol(s);
        if (ret != null) {
            return ret;
        }
        throw Util.runtimeException("Invalid token: " + s);
    }

    private static Object matchSymbol(String s) {
        Matcher m = symbolPat.matcher(s);
        if (m.matches()) {
            int gc = m.groupCount();
            String ns = m.group(1);
            String name2 = m.group(2);
            if (ns != null && ns.endsWith(":/") || name2.endsWith(":") || s.indexOf("::", 1) != -1) {
                return null;
            }
            if (s.startsWith("::")) {
                return null;
            }
            boolean isKeyword = s.charAt(0) == ':';
            Symbol sym = Symbol.intern(s.substring(isKeyword ? 1 : 0));
            if (isKeyword) {
                return Keyword.intern(sym);
            }
            return sym;
        }
        return null;
    }

    private static Object matchNumber(String s) {
        Matcher m = intPat.matcher(s);
        if (m.matches()) {
            if (m.group(2) != null) {
                if (m.group(8) != null) {
                    return BigInt.ZERO;
                }
                return Numbers.num(0L);
            }
            boolean negate = m.group(1).equals("-");
            int radix = 10;
            String n = m.group(3);
            if (n != null) {
                radix = 10;
            } else {
                n = m.group(4);
                if (n != null) {
                    radix = 16;
                } else {
                    n = m.group(5);
                    if (n != null) {
                        radix = 8;
                    } else {
                        n = m.group(7);
                        if (n != null) {
                            radix = Integer.parseInt(m.group(6));
                        }
                    }
                }
            }
            if (n == null) {
                return null;
            }
            BigInteger bn = new BigInteger(n, radix);
            if (negate) {
                bn = bn.negate();
            }
            if (m.group(8) != null) {
                return BigInt.fromBigInteger(bn);
            }
            return bn.bitLength() < 64 ? Numbers.num(bn.longValue()) : BigInt.fromBigInteger(bn);
        }
        m = floatPat.matcher(s);
        if (m.matches()) {
            if (m.group(4) != null) {
                return new BigDecimal(m.group(1));
            }
            return Double.parseDouble(s);
        }
        m = ratioPat.matcher(s);
        if (m.matches()) {
            String numerator2 = m.group(1);
            if (numerator2.startsWith("+")) {
                numerator2 = numerator2.substring(1);
            }
            return Numbers.divide((Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(numerator2))), (Object)Numbers.reduceBigInt(BigInt.fromBigInteger(new BigInteger(m.group(2)))));
        }
        return null;
    }

    private static IFn getMacro(int ch) {
        if (ch < macros.length) {
            return macros[ch];
        }
        return null;
    }

    private static boolean isMacro(int ch) {
        return ch < macros.length && macros[ch] != null;
    }

    private static boolean isTerminatingMacro(int ch) {
        return ch != 35 && ch != 39 && EdnReader.isMacro(ch);
    }

    public static List readDelimitedList(char delim, PushbackReader r, boolean isRecursive, Object opts) {
        int firstline = r instanceof LineNumberingPushbackReader ? ((LineNumberingPushbackReader)r).getLineNumber() : -1;
        ArrayList<Object> a = new ArrayList<Object>();
        while (true) {
            int ch = EdnReader.read1(r);
            while (EdnReader.isWhitespace(ch)) {
                ch = EdnReader.read1(r);
            }
            if (ch == -1) {
                if (firstline < 0) {
                    throw Util.runtimeException("EOF while reading");
                }
                throw Util.runtimeException("EOF while reading, starting at line " + firstline);
            }
            if (ch == delim) break;
            IFn macroFn = EdnReader.getMacro(ch);
            if (macroFn != null) {
                Object mret = macroFn.invoke(r, Character.valueOf((char)ch), opts);
                if (mret == r) continue;
                a.add(mret);
                continue;
            }
            EdnReader.unread(r, ch);
            Object o = EdnReader.read(r, true, null, isRecursive, opts);
            if (o == r) continue;
            a.add(o);
        }
        return a;
    }

    static {
        EdnReader.macros[34] = new StringReader();
        EdnReader.macros[59] = new CommentReader();
        EdnReader.macros[94] = new MetaReader();
        EdnReader.macros[40] = new ListReader();
        EdnReader.macros[41] = new UnmatchedDelimiterReader();
        EdnReader.macros[91] = new VectorReader();
        EdnReader.macros[93] = new UnmatchedDelimiterReader();
        EdnReader.macros[123] = new MapReader();
        EdnReader.macros[125] = new UnmatchedDelimiterReader();
        EdnReader.macros[92] = new CharacterReader();
        EdnReader.macros[35] = new DispatchReader();
        EdnReader.dispatchMacros[94] = new MetaReader();
        EdnReader.dispatchMacros[123] = new SetReader();
        EdnReader.dispatchMacros[60] = new UnreadableReader();
        EdnReader.dispatchMacros[95] = new DiscardReader();
        EOF = Keyword.intern(null, "eof");
    }

    public static class TaggedReader
    extends AFn {
        static Keyword READERS = Keyword.intern(null, "readers");
        static Keyword DEFAULT = Keyword.intern(null, "default");

        @Override
        public Object invoke(Object reader2, Object firstChar, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            Object name2 = EdnReader.read(r, true, null, false, opts);
            if (!(name2 instanceof Symbol)) {
                throw new RuntimeException("Reader tag must be a symbol");
            }
            Symbol sym = (Symbol)name2;
            return this.readTagged(r, sym, (IPersistentMap)opts);
        }

        private Object readTagged(PushbackReader reader2, Symbol tag, IPersistentMap opts) {
            Object o = EdnReader.read(reader2, true, null, true, opts);
            ILookup readers = (ILookup)RT.get(opts, READERS);
            IFn dataReader = (IFn)RT.get(readers, tag);
            if (dataReader == null) {
                dataReader = (IFn)RT.get(RT.DEFAULT_DATA_READERS.deref(), tag);
            }
            if (dataReader == null) {
                IFn defaultReader = (IFn)RT.get(opts, DEFAULT);
                if (defaultReader != null) {
                    return defaultReader.invoke(tag, o);
                }
                throw new RuntimeException("No reader function for tag " + tag.toString());
            }
            return dataReader.invoke(o);
        }
    }

    public static class UnreadableReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftangle, Object opts) {
            throw Util.runtimeException("Unreadable form");
        }
    }

    public static class UnmatchedDelimiterReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object rightdelim, Object opts) {
            throw Util.runtimeException("Unmatched delimiter: " + rightdelim);
        }
    }

    public static class SetReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftbracket, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            return PersistentHashSet.createWithCheck(EdnReader.readDelimitedList('}', r, true, opts));
        }
    }

    public static class MapReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            Object[] a = EdnReader.readDelimitedList('}', r, true, opts).toArray();
            if ((a.length & 1) == 1) {
                throw Util.runtimeException("Map literal must contain an even number of forms");
            }
            return RT.map(a);
        }
    }

    public static class VectorReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            return LazilyPersistentVector.create(EdnReader.readDelimitedList(']', r, true, opts));
        }
    }

    public static class ListReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object leftparen, Object opts) {
            List list;
            PushbackReader r = (PushbackReader)reader2;
            int line = -1;
            int column = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
                column = ((LineNumberingPushbackReader)r).getColumnNumber() - 1;
            }
            if ((list = EdnReader.readDelimitedList(')', r, true, opts)).isEmpty()) {
                return PersistentList.EMPTY;
            }
            IObj s = (IObj)((Object)PersistentList.create(list));
            return s;
        }
    }

    public static class CharacterReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object backslash, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            int ch = EdnReader.read1(r);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            String token = EdnReader.readToken(r, (char)ch, false);
            if (token.length() == 1) {
                return Character.valueOf(token.charAt(0));
            }
            if (token.equals("newline")) {
                return Character.valueOf('\n');
            }
            if (token.equals("space")) {
                return Character.valueOf(' ');
            }
            if (token.equals("tab")) {
                return Character.valueOf('\t');
            }
            if (token.equals("backspace")) {
                return Character.valueOf('\b');
            }
            if (token.equals("formfeed")) {
                return Character.valueOf('\f');
            }
            if (token.equals("return")) {
                return Character.valueOf('\r');
            }
            if (token.startsWith("u")) {
                char c = (char)EdnReader.readUnicodeChar(token, 1, 4, 16);
                if (c >= '\ud800' && c <= '\udfff') {
                    throw Util.runtimeException("Invalid character constant: \\u" + Integer.toString(c, 16));
                }
                return Character.valueOf(c);
            }
            if (token.startsWith("o")) {
                int len = token.length() - 1;
                if (len > 3) {
                    throw Util.runtimeException("Invalid octal escape sequence length: " + len);
                }
                int uc = EdnReader.readUnicodeChar(token, 1, len, 8);
                if (uc > 255) {
                    throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                }
                return Character.valueOf((char)uc);
            }
            throw Util.runtimeException("Unsupported character: \\" + token);
        }
    }

    public static class MetaReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object caret, Object opts) {
            Object meta2;
            PushbackReader r = (PushbackReader)reader2;
            int line = -1;
            int column = -1;
            if (r instanceof LineNumberingPushbackReader) {
                line = ((LineNumberingPushbackReader)r).getLineNumber();
                column = ((LineNumberingPushbackReader)r).getColumnNumber() - 1;
            }
            if ((meta2 = EdnReader.read(r, true, null, true, opts)) instanceof Symbol || meta2 instanceof String) {
                meta2 = RT.map(RT.TAG_KEY, meta2);
            } else if (meta2 instanceof Keyword) {
                meta2 = RT.map(meta2, RT.T);
            } else if (!(meta2 instanceof IPersistentMap)) {
                throw new IllegalArgumentException("Metadata must be Symbol,Keyword,String or Map");
            }
            Object o = EdnReader.read(r, true, null, true, opts);
            if (o instanceof IMeta) {
                if (line != -1 && o instanceof ISeq) {
                    meta2 = ((IPersistentMap)meta2).assoc(RT.LINE_KEY, line).assoc(RT.COLUMN_KEY, column);
                }
                if (o instanceof IReference) {
                    ((IReference)o).resetMeta((IPersistentMap)meta2);
                    return o;
                }
                Associative ometa = RT.meta(o);
                for (ISeq s = RT.seq(meta2); s != null; s = s.next()) {
                    IMapEntry kv = (IMapEntry)s.first();
                    ometa = RT.assoc(ometa, kv.getKey(), kv.getValue());
                }
                return ((IObj)o).withMeta((IPersistentMap)ometa);
            }
            throw new IllegalArgumentException("Metadata can only be applied to IMetas");
        }
    }

    public static class DispatchReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object hash2, Object opts) {
            int ch = EdnReader.read1((Reader)reader2);
            if (ch == -1) {
                throw Util.runtimeException("EOF while reading character");
            }
            IFn fn2 = dispatchMacros[ch];
            if (fn2 == null) {
                if (Character.isLetter(ch)) {
                    EdnReader.unread((PushbackReader)reader2, ch);
                    return taggedReader.invoke(reader2, ch, opts);
                }
                throw Util.runtimeException(String.format("No dispatch macro for: %c", Character.valueOf((char)ch)));
            }
            return fn2.invoke(reader2, ch, opts);
        }
    }

    public static class DiscardReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object underscore, Object opts) {
            PushbackReader r = (PushbackReader)reader2;
            EdnReader.read(r, true, null, true, opts);
            return r;
        }
    }

    public static class CommentReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object semicolon, Object opts) {
            int ch;
            Reader r = (Reader)reader2;
            while ((ch = EdnReader.read1(r)) != -1 && ch != 10 && ch != 13) {
            }
            return r;
        }
    }

    public static class StringReader
    extends AFn {
        @Override
        public Object invoke(Object reader2, Object doublequote, Object opts) {
            StringBuilder sb = new StringBuilder();
            Reader r = (Reader)reader2;
            int ch = EdnReader.read1(r);
            while (ch != 34) {
                if (ch == -1) {
                    throw Util.runtimeException("EOF while reading string");
                }
                if (ch == 92) {
                    ch = EdnReader.read1(r);
                    if (ch == -1) {
                        throw Util.runtimeException("EOF while reading string");
                    }
                    switch (ch) {
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 92: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                            break;
                        }
                        case 117: {
                            ch = EdnReader.read1(r);
                            if (Character.digit(ch, 16) == -1) {
                                throw Util.runtimeException("Invalid unicode escape: \\u" + (char)ch);
                            }
                            ch = EdnReader.readUnicodeChar((PushbackReader)r, ch, 16, 4, true);
                            break;
                        }
                        default: {
                            if (Character.isDigit(ch)) {
                                if ((ch = EdnReader.readUnicodeChar((PushbackReader)r, ch, 8, 3, false)) <= 255) break;
                                throw Util.runtimeException("Octal escape sequence must be in range [0, 377].");
                            }
                            throw Util.runtimeException("Unsupported escape character: \\" + (char)ch);
                        }
                    }
                }
                sb.append((char)ch);
                ch = EdnReader.read1(r);
            }
            return sb.toString();
        }
    }

    public static class ReaderException
    extends RuntimeException {
        final int line;
        final int column;

        public ReaderException(int line, int column, Throwable cause) {
            super(cause);
            this.line = line;
            this.column = column;
        }
    }
}

