/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IHashEq;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.MapEquivalence;
import clojure.lang.Murmur3;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class APersistentMap
extends AFn
implements IPersistentMap,
Map,
Iterable,
Serializable,
MapEquivalence,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public IPersistentCollection cons(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.assoc(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        IPersistentMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        return APersistentMap.mapEquals(this, obj);
    }

    public static boolean mapEquals(IPersistentMap m1, Object obj) {
        if (m1 == obj) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != m1.count()) {
            return false;
        }
        for (ISeq s = m1.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equals(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equiv(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        if (obj instanceof IPersistentMap && !(obj instanceof MapEquivalence)) {
            return false;
        }
        Map m = (Map)obj;
        if (m.size() != this.size()) {
            return false;
        }
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            boolean found = m.containsKey(e.getKey());
            if (found && Util.equiv(e.getValue(), m.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            this._hash = APersistentMap.mapHash(this);
        }
        return this._hash;
    }

    public static int mapHash(IPersistentMap m) {
        int hash2 = 0;
        for (ISeq s = m.seq(); s != null; s = s.next()) {
            Map.Entry e = (Map.Entry)s.first();
            hash2 += (e.getKey() == null ? 0 : e.getKey().hashCode()) ^ (e.getValue() == null ? 0 : e.getValue().hashCode());
        }
        return hash2;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            this._hasheq = Murmur3.hashUnordered(this);
        }
        return this._hasheq;
    }

    public static int mapHasheq(IPersistentMap m) {
        return Murmur3.hashUnordered(m);
    }

    @Override
    public Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    @Override
    public Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public Set entrySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return APersistentMap.this.iterator();
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public int hashCode() {
                return APersistentMap.this.hashCode();
            }

            @Override
            public boolean contains(Object o) {
                Map.Entry e;
                IMapEntry found;
                return o instanceof Map.Entry && (found = APersistentMap.this.entryAt((e = (Map.Entry)o).getKey())) != null && Util.equals(found.getValue(), e.getValue());
            }
        };
    }

    public Object get(Object key2) {
        return this.valAt(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }

            @Override
            public boolean contains(Object o) {
                return APersistentMap.this.containsKey(o);
            }
        };
    }

    public Object put(Object key2, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count();
    }

    public Collection values() {
        return new AbstractCollection(){

            @Override
            public Iterator iterator() {
                final Iterator mi = APersistentMap.this.iterator();
                return new Iterator(){

                    @Override
                    public boolean hasNext() {
                        return mi.hasNext();
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)mi.next();
                        return e.getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return APersistentMap.this.count();
            }
        };
    }

    public static class ValSeq
    extends ASeq {
        ISeq seq;

        public static ValSeq create(ISeq seq2) {
            if (seq2 == null) {
                return null;
            }
            return new ValSeq(seq2);
        }

        private ValSeq(ISeq seq2) {
            this.seq = seq2;
        }

        private ValSeq(IPersistentMap meta2, ISeq seq2) {
            super(meta2);
            this.seq = seq2;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getValue();
        }

        @Override
        public ISeq next() {
            return ValSeq.create(this.seq.next());
        }

        @Override
        public ValSeq withMeta(IPersistentMap meta2) {
            return new ValSeq(meta2, this.seq);
        }
    }

    public static class KeySeq
    extends ASeq {
        ISeq seq;

        public static KeySeq create(ISeq seq2) {
            if (seq2 == null) {
                return null;
            }
            return new KeySeq(seq2);
        }

        private KeySeq(ISeq seq2) {
            this.seq = seq2;
        }

        private KeySeq(IPersistentMap meta2, ISeq seq2) {
            super(meta2);
            this.seq = seq2;
        }

        @Override
        public Object first() {
            return ((Map.Entry)this.seq.first()).getKey();
        }

        @Override
        public ISeq next() {
            return KeySeq.create(this.seq.next());
        }

        @Override
        public KeySeq withMeta(IPersistentMap meta2) {
            return new KeySeq(meta2, this.seq);
        }
    }
}

