;; Library imports
(ns org.buntin.authorize
  (:gen-class)
  (:require [clojure.http.client :as client]
            [clojure.contrib.str-utils :as str-utils])
  (:import (java.net URLEncoder)
           (java.nio.charset Charset)
           (com.csvreader CsvReader)))

;; Debugging
(defn test-mode []
  (def *debug* true)
  (def *url* "https://test.authorize.net/gateway/transact.dll"))

(defn production-mode []
  (def *debug* false)
  (def *url* "https://secure.authorize.net/gateway/transact.dll"))

(test-mode)

;; Default query map
(def *default-query* {:x_delim_data "TRUE" 
                      :x_version "3.1" 
                      :x_relay_response "FALSE"
                      :x_test_request *debug*})

;; Request
(defn- do-request [url default-query trans-info]
  "Executes http client"
  (client/request url "post" "" "" 
                  (client/url-encode 
                   (conj default-query trans-info))))

(defn- csv-reader [response]
  (CsvReader/parse (first (response :body-seq))))

(defn- api-response [reader]
  (cond (.readRecord reader)
        {:code (.get reader 0),
         :subcode (.get reader 1),
         :reason_code (.get reader 2),
         :reason_text (.get reader 3),
         :auth_text (.get reader 4),
         :avs_response (.get reader 5),
         :transaction_id (.get reader 6),
         :invoice_number (.get reader 7),
         :description (.get reader 8),
         :amount (.get reader 9),
         :method (.get reader 10),
         :transaction_type (.get reader 11),
         :customer_id (.get reader 12),
         :first_name (.get reader 13)
         :last_name (.get reader 14)
         :company (.get reader 15)
         :address (.get reader 16)
         :city (.get reader 17)
         :state (.get reader 18)
         :zip_code (.get reader 19)
         :country (.get reader 20)
         :phone (.get reader 21)
         :fax (.get reader 22)
         :email (.get reader 23)
         :ship_first_name (.get reader 24)
         :ship_last_name (.get reader 25)
         :ship_company (.get reader 26)
         :ship_address (.get reader 27)
         :ship_city (.get reader 28)
         :ship_state (.get reader 29)
         :ship_zip_code (.get reader 30)
         :ship_country (.get reader 31)
         :tax (.get reader 32)
         :duty (.get reader 33)
         :freight (.get reader 34)
         :tax_exempt (.get reader 35)
         :purchase_order_number (.get reader 36)
         :md5_hash (.get reader 37)
         :card_code_response (.get reader 38)
         :cavv_response (.get reader 39)}
        :else
        {:code "911", 
         :reason_code "911" 
         :reason_text "API Failure"}))

(defn process-payment [trans-info]
  "Basic method to handle api request and response"
  (api-response 
   (csv-reader 
    (do-request *url* *default-query* trans-info))))

(defn void-transaction [trans-info]
  (api-response 
   (csv-reader 
    (do-request *url* 
                *default-query* 
                (conj {:x_type "VOID"} trans-info)))))

(defn echeck-payment [trans-info]
  (api-response
   (csv-reader
    (do-request *url*
                *default-query*
                (conj {:x_method "ECHECK"
                       :x_recurring_billing "FALSE"} 
                      trans-info)))))