(ns pylon.test
  (:require [pylon.classes]
            [cljs.nodejs])
  (:use-macros [pylon.macros :only [defclass super]]))

(defclass Pony
  (defn pony-up [] "everypony"))

(defclass DeterministicPony :extends Pony
  (defn pony-up []
    (str "anypony and " (super))))

(defclass Ohai
  (defn constructor [name]
    (set! @.name name))
  (defn hello []
    (str "Hello " @.name  "!")))

(defclass OhaiWithSuperclass :extends Pony
  (defn constructor []
    (set! @.name (@.pony-up)))
  (defn hello []
    (str "Hello " @.name "!")))

(defclass OhaiWithMixin :mixin [Pony]
  (defn constructor []
    (set! @.name (.pony-up this)))
  (defn hello []
    (str "Hello " @.name "!")))

(defclass OhaiWithSuperMacro :extends OhaiWithSuperclass
  (defn constructor []
    (super)
    (set! @.name (str "anypony and " @.name)))
  (defn hello []
    (str "Hello " @.name "!")))

(defclass TheDashProblem :extends DeterministicPony
  (defn constructor []
    (set! @.name (.pony-up this)))
  (defn hello []
    (str "Hello " @.name "!")))

(defn main [& args]
  (.log js/console (.hello (Ohai. "sailor")))
  (.log js/console (.hello (OhaiWithSuperclass.)))
  (.log js/console (.hello (OhaiWithMixin.)))
  (.log js/console (.hello (OhaiWithSuperMacro.)))
  (.log js/console (.hello (TheDashProblem.)))
  )

(set! *main-cli-fn* main)
