(ns pylon.test
  (:require [pylon.classes]
            [cljs.nodejs])
  (:use-macros [pylon.macros :only [defclass super]]))

(defclass Pony
  (defn pony-up [] "everypony"))

(defclass DeterministicPony :extends Pony
  (defn pony-up []
    (str "anypony and " (super))))

(defclass Ohai
  (defn constructor [name]
    (set! (.-name this) name))
  (defn hello []
    (str "Hello " (.-name this) "!")))

(defclass OhaiWithSuperclass :extends Pony
  (defn constructor []
    (set! (.-name this) (.pony-up this)))
  (defn hello []
    (str "Hello " (.-name this) "!")))

(defclass OhaiWithMixin :mixin [Pony]
  (defn constructor []
    (set! (.-name this) (.pony-up this)))
  (defn hello []
    (str "Hello " (.-name this) "!")))

(defclass OhaiWithSuperMacro :extends OhaiWithSuperclass
  (defn constructor []
    (super)
    (set! (.-name this) (str "anypony and " (.-name this))))
  (defn hello []
    (str "Hello " (.-name this) "!")))

(defclass TheDashProblem :extends DeterministicPony
  (defn constructor []
    (set! (.-name this) (.pony-up this)))
  (defn hello []
    (str "Hello " (.-name this) "!")))

(defn main [& args]
  (.log js/console (.hello (Ohai. "sailor")))
  (.log js/console (.hello (OhaiWithSuperclass.)))
  (.log js/console (.hello (OhaiWithMixin.)))
  (.log js/console (.hello (OhaiWithSuperMacro.)))
  (.log js/console (.hello (TheDashProblem.)))
  )

(set! *main-cli-fn* main)
