(ns pylon.test
  (:require [pylon.classes :as c]
            [cljs.nodejs])
  (:require-macros [cljs.node.require :as node])
  (:use-macros [pylon.macros :only [defclass super]]))

(defclass Hello
  (defn constructor [name]
    (aset this "name" name))
  (defn hello []
    (console/log (str "Hello " (.-name this) "!")))
  (defn test-foo []
    "hai"))

(.test-foo (Hello. "foo"))
(.hello (Hello. "Kitty"))

(defclass HelloSailor :extends Hello
  (defn constructor []
    (super "sailor")))

(defn main [& args]
  (.hello (Hello. "Kitty"))
  (.hello (HelloSailor.)))

(set! *main-cli-fn* main)
