/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.Undefined;
import jdk.nashorn.internal.runtime.linker.Bootstrap;

public class JavaAdapterServices {
    private static final ThreadLocal<ScriptObject> classOverrides = new ThreadLocal();

    private JavaAdapterServices() {
    }

    public static MethodHandle getHandle(ScriptFunction fn, MethodType type) {
        return JavaAdapterServices.adaptHandle(fn.getBoundInvokeHandle(null), type);
    }

    public static MethodHandle getHandle(Object obj, String name, MethodType type) {
        if (!(obj instanceof ScriptObject)) {
            throw ECMAErrors.typeError("not.an.object", ScriptRuntime.safeToString(obj));
        }
        ScriptObject sobj = (ScriptObject)obj;
        if ("toString".equals(name) && !sobj.hasOwnProperty("toString")) {
            return null;
        }
        Object fnObj = sobj.get(name);
        if (fnObj instanceof ScriptFunction) {
            return JavaAdapterServices.adaptHandle(((ScriptFunction)fnObj).getBoundInvokeHandle(sobj), type);
        }
        if (fnObj == null || fnObj instanceof Undefined) {
            return null;
        }
        throw ECMAErrors.typeError("not.a.function", name);
    }

    public static ScriptObject getClassOverrides() {
        ScriptObject overrides = classOverrides.get();
        assert (overrides != null);
        return overrides;
    }

    static void setClassOverrides(ScriptObject overrides) {
        classOverrides.set(overrides);
    }

    private static MethodHandle adaptHandle(MethodHandle handle, MethodType type) {
        return Bootstrap.getLinkerServices().asType(ScriptObject.pairArguments(handle, type, false), type);
    }
}

