/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.security.ProtectionDomain;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.NashornLoader;

final class StructureLoader
extends NashornLoader {
    private static final String JS_OBJECT_PREFIX_EXTERNAL = Compiler.binaryName("jdk/nashorn/internal/scripts") + '.' + CompilerConstants.JS_OBJECT_PREFIX.symbolName();

    StructureLoader(ClassLoader parent, Context context) {
        super(parent, context);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
        return super.loadClassTrusted(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name.startsWith(JS_OBJECT_PREFIX_EXTERNAL)) {
            return this.generateClass(name, name.substring(JS_OBJECT_PREFIX_EXTERNAL.length()));
        }
        return super.findClass(name);
    }

    private Class<?> generateClass(String name, String descriptor) {
        Context context = this.getContext();
        if (context == null) {
            context = Context.getContextTrusted();
        }
        byte[] code = new ObjectClassGenerator(context).generate(descriptor);
        return this.defineClass(name, code, 0, code.length, new ProtectionDomain(null, this.getPermissions(null)));
    }
}

