/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.Map;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyListener;
import jdk.nashorn.internal.runtime.ScriptObject;

public class PropertyListenerManager
implements PropertyListener {
    private Map<PropertyListener, Boolean> listeners;
    private static int listenersAdded;
    private static int listenersRemoved;

    public static int getListenersAdded() {
        return listenersAdded;
    }

    public static int getListenersRemoved() {
        return listenersRemoved;
    }

    public final int getListenerCount() {
        return this.listeners != null ? this.listeners.size() : 0;
    }

    public final synchronized void addPropertyListener(PropertyListener listener) {
        if (this.listeners == null) {
            this.listeners = new WeakHashMap<PropertyListener, Boolean>();
        }
        if (Context.DEBUG) {
            ++listenersAdded;
        }
        this.listeners.put(listener, Boolean.TRUE);
    }

    public final synchronized void removePropertyListener(PropertyListener listener) {
        if (this.listeners != null) {
            if (Context.DEBUG) {
                ++listenersRemoved;
            }
            this.listeners.remove(listener);
        }
    }

    protected final synchronized void notifyPropertyAdded(ScriptObject object, Property prop) {
        if (this.listeners != null) {
            for (PropertyListener listener : this.listeners.keySet()) {
                listener.propertyAdded(object, prop);
            }
        }
    }

    protected final synchronized void notifyPropertyDeleted(ScriptObject object, Property prop) {
        if (this.listeners != null) {
            for (PropertyListener listener : this.listeners.keySet()) {
                listener.propertyDeleted(object, prop);
            }
        }
    }

    protected final synchronized void notifyPropertyModified(ScriptObject object, Property oldProp, Property newProp) {
        if (this.listeners != null) {
            for (PropertyListener listener : this.listeners.keySet()) {
                listener.propertyModified(object, oldProp, newProp);
            }
        }
    }

    @Override
    public final void propertyAdded(ScriptObject object, Property prop) {
        this.notifyPropertyAdded(object, prop);
    }

    @Override
    public final void propertyDeleted(ScriptObject object, Property prop) {
        this.notifyPropertyDeleted(object, prop);
    }

    @Override
    public final void propertyModified(ScriptObject object, Property oldProp, Property newProp) {
        this.notifyPropertyModified(object, oldProp, newProp);
    }
}

