/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.AbstractList;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import jdk.nashorn.internal.runtime.JSType;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.linker.InvokeByName;

public class ListAdapter
extends AbstractList<Object>
implements RandomAccess,
Deque<Object> {
    private static final InvokeByName PUSH = new InvokeByName("push", ScriptObject.class, Void.TYPE, Object.class);
    private static final InvokeByName UNSHIFT = new InvokeByName("unshift", ScriptObject.class, Void.TYPE, Object.class);
    private static final InvokeByName POP = new InvokeByName("pop", ScriptObject.class, Object.class, new Class[0]);
    private static final InvokeByName SHIFT = new InvokeByName("shift", ScriptObject.class, Object.class, new Class[0]);
    private static final InvokeByName SPLICE_ADD = new InvokeByName("splice", ScriptObject.class, Void.TYPE, Integer.TYPE, Integer.TYPE, Object.class);
    private static final InvokeByName SPLICE_REMOVE = new InvokeByName("splice", ScriptObject.class, Void.TYPE, Integer.TYPE, Integer.TYPE);
    private final ScriptObject obj;

    public ListAdapter(ScriptObject obj) {
        this.obj = obj;
    }

    @Override
    public int size() {
        return JSType.toInt32(this.obj.getLength());
    }

    @Override
    public Object get(int index) {
        this.checkRange(index);
        return this.obj.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        this.checkRange(index);
        Object prevValue = this.get(index);
        this.obj.set(index, element, false);
        return prevValue;
    }

    private void checkRange(int index) {
        if (index < 0 || index >= this.size()) {
            throw ListAdapter.invalidIndex(index);
        }
    }

    @Override
    public void push(Object e) {
        this.addFirst(e);
    }

    @Override
    public boolean add(Object e) {
        this.addLast(e);
        return true;
    }

    @Override
    public void addFirst(Object e) {
        try {
            Object fn = UNSHIFT.getGetter().invokeExact(this.obj);
            ListAdapter.checkFunction(fn, UNSHIFT);
            UNSHIFT.getInvoker().invokeExact(fn, this.obj, e);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void addLast(Object e) {
        try {
            Object fn = PUSH.getGetter().invokeExact(this.obj);
            ListAdapter.checkFunction(fn, PUSH);
            PUSH.getInvoker().invokeExact(fn, this.obj, e);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void add(int index, Object e) {
        block7: {
            try {
                if (index < 0) {
                    throw ListAdapter.invalidIndex(index);
                }
                if (index == 0) {
                    this.addFirst(e);
                    break block7;
                }
                int size = this.size();
                if (index < size) {
                    Object fn = SPLICE_ADD.getGetter().invokeExact(this.obj);
                    ListAdapter.checkFunction(fn, SPLICE_ADD);
                    SPLICE_ADD.getInvoker().invokeExact(fn, this.obj, index, 0, e);
                    break block7;
                }
                if (index == size) {
                    this.addLast(e);
                    break block7;
                }
                throw ListAdapter.invalidIndex(index);
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    private static void checkFunction(Object fn, InvokeByName invoke) {
        if (!(fn instanceof ScriptFunction)) {
            throw new UnsupportedOperationException("The script object doesn't have a function named " + invoke.getName());
        }
    }

    private static IndexOutOfBoundsException invalidIndex(int index) {
        return new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public boolean offer(Object e) {
        return this.offerLast(e);
    }

    @Override
    public boolean offerFirst(Object e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(Object e) {
        this.addLast(e);
        return true;
    }

    @Override
    public Object pop() {
        return this.removeFirst();
    }

    @Override
    public Object remove() {
        return this.removeFirst();
    }

    @Override
    public Object removeFirst() {
        this.checkNonEmpty();
        return this.invokeShift();
    }

    @Override
    public Object removeLast() {
        this.checkNonEmpty();
        return this.invokePop();
    }

    private void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object remove(int index) {
        if (index < 0) {
            throw ListAdapter.invalidIndex(index);
        }
        if (index == 0) {
            return this.invokeShift();
        }
        int maxIndex = this.size() - 1;
        if (index < maxIndex) {
            Object prevValue = this.get(index);
            this.invokeSpliceRemove(index, 1);
            return prevValue;
        }
        if (index == maxIndex) {
            return this.invokePop();
        }
        throw ListAdapter.invalidIndex(index);
    }

    private Object invokeShift() {
        try {
            Object fn = SHIFT.getGetter().invokeExact(this.obj);
            ListAdapter.checkFunction(fn, SHIFT);
            return SHIFT.getInvoker().invokeExact(fn, this.obj);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private Object invokePop() {
        try {
            Object fn = POP.getGetter().invokeExact(this.obj);
            ListAdapter.checkFunction(fn, POP);
            return POP.getInvoker().invokeExact(fn, this.obj);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.invokeSpliceRemove(fromIndex, toIndex - fromIndex);
    }

    private void invokeSpliceRemove(int fromIndex, int count) {
        try {
            Object fn = SPLICE_REMOVE.getGetter().invokeExact(this.obj);
            ListAdapter.checkFunction(fn, SPLICE_REMOVE);
            SPLICE_REMOVE.getInvoker().invokeExact(fn, this.obj, fromIndex, count);
        }
        catch (Error | RuntimeException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public Object poll() {
        return this.pollFirst();
    }

    @Override
    public Object pollFirst() {
        return this.isEmpty() ? null : this.invokeShift();
    }

    @Override
    public Object pollLast() {
        return this.isEmpty() ? null : this.invokePop();
    }

    @Override
    public Object peek() {
        return this.peekFirst();
    }

    @Override
    public Object peekFirst() {
        return this.isEmpty() ? null : this.get(0);
    }

    @Override
    public Object peekLast() {
        return this.isEmpty() ? null : this.get(this.size() - 1);
    }

    @Override
    public Object element() {
        return this.getFirst();
    }

    @Override
    public Object getFirst() {
        this.checkNonEmpty();
        return this.get(0);
    }

    @Override
    public Object getLast() {
        this.checkNonEmpty();
        return this.get(this.size() - 1);
    }

    @Override
    public Iterator<Object> descendingIterator() {
        final ListIterator it = this.listIterator(this.size());
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return it.hasPrevious();
            }

            @Override
            public Object next() {
                return it.previous();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return ListAdapter.removeOccurrence(o, this.iterator());
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return ListAdapter.removeOccurrence(o, this.descendingIterator());
    }

    private static boolean removeOccurrence(Object o, Iterator<Object> it) {
        while (it.hasNext()) {
            Object e = it.next();
            if (!(o == null ? e == null : o.equals(e))) continue;
            it.remove();
            return true;
        }
        return false;
    }
}

