/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.CompiledFunction;
import jdk.nashorn.internal.runtime.CompiledFunctions;
import jdk.nashorn.internal.runtime.ScriptFunctionData;

public final class FinalScriptFunctionData
extends ScriptFunctionData {
    FinalScriptFunctionData(String name, int arity, CompiledFunctions functions, boolean isStrict, boolean isBuiltin, boolean isConstructor) {
        super(name, arity, isStrict, isBuiltin, isConstructor);
        this.code.addAll(functions);
    }

    FinalScriptFunctionData(String name, MethodHandle mh, MethodHandle[] specs, boolean isStrict, boolean isBuiltin, boolean isConstructor) {
        super(name, FinalScriptFunctionData.arity(mh), isStrict, isBuiltin, isConstructor);
        this.addInvoker(mh);
        if (specs != null) {
            for (MethodHandle spec : specs) {
                this.addInvoker(spec);
            }
        }
    }

    private void addInvoker(MethodHandle mh) {
        boolean needsCallee = FinalScriptFunctionData.needsCallee(mh);
        if (FinalScriptFunctionData.isConstructor(mh)) {
            assert (this.isConstructor());
            this.code.add(new CompiledFunction(mh.type(), Lookup.MH.insertArguments(mh, 0, false), this.composeConstructor(Lookup.MH.insertArguments(mh, 0, true), needsCallee)));
        } else {
            this.code.add(new CompiledFunction(mh.type(), mh));
        }
    }

    private static int arity(MethodHandle mh) {
        if (FinalScriptFunctionData.isVarArg(mh)) {
            return -1;
        }
        return mh.type().parameterCount() - 1 - (FinalScriptFunctionData.needsCallee(mh) ? 1 : 0) - (FinalScriptFunctionData.isConstructor(mh) ? 1 : 0);
    }

    private static boolean isConstructor(MethodHandle mh) {
        return mh.type().parameterCount() >= 1 && mh.type().parameterType(0) == Boolean.TYPE;
    }
}

