/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Logging;
import jdk.nashorn.internal.runtime.options.Options;

public final class DebugLogger {
    private final Logger logger;
    private final boolean isEnabled;
    private int indent;
    private static final int INDENT_SPACE = 4;

    public DebugLogger(String loggerName) {
        this(loggerName, null);
    }

    public DebugLogger(String loggerName, String property) {
        this.logger = property != null && Options.getBooleanProperty(property) ? Logging.getOrCreateLogger(loggerName, Level.INFO) : Logging.getLogger(loggerName);
        this.isEnabled = this.logger.getLevel() != Level.OFF;
    }

    public PrintWriter getOutputStream() {
        return Context.getCurrentErr();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void indent(int pos) {
        if (this.isEnabled) {
            this.indent += pos * 4;
        }
    }

    public void indent() {
        this.indent += 4;
    }

    public void unindent() {
        this.indent -= 4;
        if (this.indent < 0) {
            this.indent = 0;
        }
    }

    public boolean levelAbove(Level level) {
        return this.logger.getLevel().intValue() > level.intValue();
    }

    public void finest(String str) {
        this.log(Level.FINEST, str);
    }

    public void finest(Object ... objs) {
        this.log(Level.FINEST, objs);
    }

    public void finer(String str) {
        this.log(Level.FINER, str);
    }

    public void finer(Object ... objs) {
        this.log(Level.FINER, objs);
    }

    public void fine(String str) {
        this.log(Level.FINE, str);
    }

    public void fine(Object ... objs) {
        this.log(Level.FINE, objs);
    }

    public void config(String str) {
        this.log(Level.CONFIG, str);
    }

    public void config(Object ... objs) {
        this.log(Level.CONFIG, objs);
    }

    public void info(String str) {
        this.log(Level.INFO, str);
    }

    public void info(Object ... objs) {
        this.log(Level.INFO, objs);
    }

    public void warning(String str) {
        this.log(Level.WARNING, str);
    }

    public void warning(Object ... objs) {
        this.log(Level.WARNING, objs);
    }

    public void severe(String str) {
        this.log(Level.SEVERE, str);
    }

    public void severe(Object ... objs) {
        this.log(Level.SEVERE, objs);
    }

    public void log(Level level, String str) {
        if (this.isEnabled) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.indent; ++i) {
                sb.append(' ');
            }
            sb.append(str);
            this.logger.log(level, sb.toString());
        }
    }

    public void log(Level level, Object ... objs) {
        if (this.isEnabled) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.indent; ++i) {
                sb.append(' ');
            }
            for (Object obj : objs) {
                sb.append(obj);
            }
            this.logger.log(level, sb.toString());
        }
    }
}

